package volumeviz.sample.roiManip;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.SoPath;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.draggers.SoTabBoxDragger;
import com.openinventor.inventor.nodes.SoMaterial;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.sensors.SoFieldSensor;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor.CameraMode;
import com.openinventor.ldm.manips.SoROIManip;
import com.openinventor.ldm.nodes.SoROI;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeRender;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{
  private SoROI m_ROI;
  private SoROIManip m_ROIManip;
  private SoSeparator m_root;
  private IViewerExaminer m_viewer;
  private BBoxSwitch m_subVolBBoxSwitch;
  private BBoxSwitch m_ROIBBoxSwitch;

  private SbBox3i32 m_boxInitSize;
  private SbBox3i32 m_subVolInitSize;

  private SoFieldSensor m_roiManip_sensor;
  private SoFieldSensor m_subVol_sensor;

  private JCheckBox m_subVolManipBox = new JCheckBox("show Manip");
  private JCheckBox m_ROIManipBox = new JCheckBox("show Manip");
  private JButton m_resetSubVolButton;
  private JButton m_resetBoxButton;

  boolean m_ROIManipActivated = true;
  boolean m_subVolManipActivated = false;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("ROI Manip");
  }

  @Override
  public void start() {
    m_viewer = ViewerComponentsFactory.createViewerExaminer();

    // Volume Data
    SoVolumeData vol_data = new SoVolumeData();
    vol_data.fileName.setValue("$OIVJHOME/data/volumeviz/virus.am");

    // Get the voxel dimensions of the volume
    SbVec3i32 vol_dim = vol_data.data.getSize();
    SbVec3i32 dimensions = new SbVec3i32(vol_dim.getX(),
                                     vol_dim.getY(),
                                     vol_dim.getZ());

    // Transfer function
    SoTransferFunction transferFunction = new SoTransferFunction();
    int numEntries = 256;
    for (int i = 0; i < numEntries; i++) {
      float f = (float)i / 255;
      SbColor rgb = new SbColor();
      rgb.setHSVValue( 0.916f * f, 1, 1 );
      transferFunction.colorMap.set1Value(4 * i + 0, rgb.getValueAt(0)); // red
      transferFunction.colorMap.set1Value(4 * i + 1, rgb.getValueAt(1)); // green
      transferFunction.colorMap.set1Value(4 * i + 2, rgb.getValueAt(2)); // blue
      transferFunction.colorMap.set1Value(4 * i + 3, 0.3f); // alpha
    }

    // ROI / ROIManip
    // Initialize both ROI box and subvolume to be the entire volume.
    // Constrain the ROIManip to stay inside the volume.
    m_ROI = new SoROI();
    m_ROIManip = new SoROIManip();
    m_boxInitSize = new SbBox3i32(new SbVec3i32(0, 0, 0),
                                dimensions.minus(new SbVec3i32(1, 1, 1)));
    m_subVolInitSize = new SbBox3i32(new SbVec3i32(0, 0, 0),
                                   dimensions.minus(new SbVec3i32(1, 1, 1)));
    m_ROIManip.box.setValue(m_boxInitSize);
    m_ROIManip.subVolume.setValue(m_subVolInitSize);
    m_ROIManip.constrained.setValue(true);

    m_subVolBBoxSwitch = new BBoxSwitch(vol_data, m_ROIManip.subVolume, new SbColor(1, 0, 0));
    m_ROIBBoxSwitch = new BBoxSwitch(vol_data, m_ROIManip.box, new SbColor(0, 1, 0));

    // PickStyle
    // So that VolumeRender is not pickable -- remember that the volume
    // is pickable even where the voxels are completely transparent.
    // If we don't do this the manip will not be useable in some cases
    // where the user should expect it to be useable.
    SoPickStyle pickStyle = new SoPickStyle();
    pickStyle.style.setValue(SoPickStyle.Styles.UNPICKABLE);

    // Top separator
    m_root = new SoSeparator();
    { // Build Scene Graph
      // Volume Data
      m_root.addChild(vol_data);
      m_root.addChild(transferFunction);
      m_root.addChild(m_ROIManip);
      m_root.addChild(m_subVolBBoxSwitch);
      m_root.addChild(m_ROIBBoxSwitch);
      m_root.addChild(pickStyle);
      // VolumeRender
      m_root.addChild(new SoVolumeRender());
    }

    Runnable box_run = new Runnable() {
      @Override
      public void run() {
        m_ROIBBoxSwitch.update();
      }
    };
    m_roiManip_sensor = new SoFieldSensor(box_run);
    m_roiManip_sensor.attach(m_ROIManip.box);

    Runnable subVol_run = new Runnable() {
      @Override
      public void run() {
        m_subVolBBoxSwitch.update();
        if (m_ROIManip.relative.getValue() || m_ROI.relative.getValue()) {
          m_ROIBBoxSwitch.update();
          float[] bounds = m_subVolBBoxSwitch.getBBoxBounds();
          m_ROIBBoxSwitch.setTranslation(bounds[0], bounds[1], bounds[2]);
        }
      }
    };
    m_subVol_sensor = new SoFieldSensor(subVol_run);
    m_subVol_sensor.attach(m_ROIManip.subVolume);

    // Set up viewer and dialog
    // Use orthographic camera by default, works better with VolumePro
    m_viewer.getRenderArea().setCameraType(CameraMode.ORTHOGRAPHIC);
    m_viewer.setSceneGraph(m_root);
    m_viewer.getRenderArea().getRootSceneGraph().setInteractionMode(InteractionMode.SELECTION);
    m_viewer.viewAll();

    jbInit();
  }

  @Override
  public void stop()
  {
    m_viewer.dispose();
  }

  private void jbInit() {
    // SubVolume
    GridLayout gl1 = new GridLayout(2, 1);
    gl1.setVgap(10);
    JPanel subVolume_panel = new JPanel(gl1);
    TitledBorder tb1 = new TitledBorder(BorderFactory.createEtchedBorder
                                        (Color.red,new Color(148, 145, 140)),"SubVolume");
    subVolume_panel.setBorder(tb1);

    m_subVolManipBox.setSelected(false);
    m_subVolManipBox.addItemListener(new ManipBoxListener(false));
    m_resetSubVolButton = new JButton("Reset");
    m_resetSubVolButton.setEnabled(false);
    m_resetSubVolButton.addMouseListener(new ResetSubVolListener());
    GridLayout gl2 = new GridLayout(1, 3);
    gl2.setHgap(10);
    JPanel subVolManip_panel = new JPanel(gl2);
    subVolManip_panel.add(m_subVolManipBox);
    subVolManip_panel.add(m_resetSubVolButton);
    subVolManip_panel.add(new JPanel());

    JCheckBox bbox_subV = new JCheckBox("show BBox");
    bbox_subV.addItemListener(new BBoxListener(false));

    subVolume_panel.add(subVolManip_panel);
    subVolume_panel.add(bbox_subV);

    // ROI Box
    GridLayout gl3 = new GridLayout(4, 1);
    gl3.setVgap(7);
    JPanel roiBox_panel = new JPanel(gl3);
    TitledBorder tb2 = new TitledBorder(BorderFactory.createEtchedBorder
                                        (Color.green,new Color(148, 145, 140)),"ROI Box");
    roiBox_panel.setBorder(tb2);

    m_ROIManipBox.setSelected(true);
    m_ROIManipBox.addItemListener(new ManipBoxListener(true));
    m_resetBoxButton = new JButton("Reset");
    m_resetBoxButton.setEnabled(true);
    m_resetBoxButton.addMouseListener(new ResetROIListener());
    JPanel ROIManip_panel = new JPanel(gl2);
    ROIManip_panel.add(m_ROIManipBox);
    ROIManip_panel.add(m_resetBoxButton);
    ROIManip_panel.add(new JPanel());

    JCheckBox bbox_roi = new JCheckBox("show BBox");
    bbox_roi.addItemListener(new BBoxListener(true));

    JPanel relative_panel = new JPanel(new GridLayout(1, 2));
    JCheckBox full_box = new JCheckBox("relative to full volume");
    full_box.setSelected(true);
    JCheckBox subVolume_box = new JCheckBox("relative to subvolume");
    subVolume_box.addItemListener(new RelativeBoxListener());
    ButtonGroup bg = new ButtonGroup();
    bg.add(full_box);
    bg.add(subVolume_box);
    relative_panel.add(full_box);
    relative_panel.add(subVolume_box);

    JPanel flags_panel = new JPanel();
    JLabel flags_txt = new JLabel("Flags");
    String[] flags_items = {
        "SUB_VOLUME",
        "EXCLUSION_BOX",
        "CROSS",
        "CROSS_INVERT",
        "FENCE"
    };
    JComboBox<String> flags_box = new JComboBox<>(flags_items);
    flags_box.setPreferredSize(new Dimension(145, 20));
    flags_box.addActionListener(new FlagsBoxListener(flags_box));
    flags_panel.add(flags_txt);
    flags_panel.add(flags_box);

    roiBox_panel.add(ROIManip_panel);
    roiBox_panel.add(bbox_roi);
    roiBox_panel.add(relative_panel);
    roiBox_panel.add(flags_panel);

    // tools panel
    JCheckBox constrained_box = new JCheckBox("Constrained manip");
    constrained_box.setSelected(true);
    constrained_box.addItemListener(new ConstraintBoxListener());
    JPanel tools_panel = new JPanel(new BorderLayout());
    tools_panel.setBorder(BorderFactory.createRaisedBevelBorder());
    tools_panel.add(constrained_box, BorderLayout.NORTH);
    tools_panel.add(subVolume_panel, BorderLayout.CENTER);
    tools_panel.add(roiBox_panel, BorderLayout.SOUTH);

    JPanel main_panel = new JPanel();
    main_panel.add(tools_panel);

    // ScrollPane
    JScrollPane scroll_pane = new JScrollPane(main_panel);

    // SplitPane
    JPanel iPanel = new JPanel(new BorderLayout());
    final Component component = m_viewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    iPanel.add(component,BorderLayout.CENTER);
    iPanel.setMinimumSize(new Dimension(1, 1));

    JSplitPane split_pane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true,
                                           iPanel, scroll_pane);
    split_pane.setOneTouchExpandable(true);
    split_pane.setResizeWeight(0.6);

    setLayout(new BorderLayout());
    add(split_pane);
  }

  class ManipBoxListener implements ItemListener {

    private boolean m_boxManip;

    public ManipBoxListener(boolean box_manip) {
      m_boxManip = box_manip;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
      SoROI roi;
      if (!m_ROIManipActivated && !m_subVolManipActivated)
        roi = m_ROI;
      else
        roi = m_ROIManip;

      SoSearchAction searchAction = new SoSearchAction();
      searchAction.setNode(roi);
      searchAction.apply(m_root);
      SoPath path = searchAction.getPath();

      if (e.getStateChange() == ItemEvent.DESELECTED) {
        if (!m_ROIManipBox.isSelected() && !m_subVolManipBox.isSelected())
          m_ROIManip.replaceManip(path, m_ROI);
        if (m_boxManip)
          m_ROIManipActivated = false;
        else
          m_subVolManipActivated = false;
      }
      else if (e.getStateChange() == ItemEvent.SELECTED) {
        m_ROIManip.replaceNode(path);
        ((SoTabBoxDragger)m_ROIManip.getDragger()).adjustScaleTabSize();
        SoMaterial material = (SoMaterial)(m_ROIManip.getDragger()
                                           .getPart("tabPlane1.scaleTabMaterial"));
        if (m_boxManip) {
          material.diffuseColor.setValue(0, 1, 0);
          material.emissiveColor.setValue(0, 1, 0);
          m_ROIManip.boxOn.setValue(true);
          m_ROIManipActivated = true;
          m_subVolManipBox.setSelected(false);
        } else {
          material.diffuseColor.setValue(1, 0, 0);
          material.emissiveColor.setValue(1, 0, 0);
          m_ROIManip.boxOn.setValue(false);
          m_subVolManipActivated = true;
          m_ROIManipBox.setSelected(false);
        }
      }
      m_resetSubVolButton.setEnabled(m_subVolManipActivated);
      m_resetBoxButton.setEnabled(m_ROIManipActivated);
    }
  }

  class BBoxListener implements ItemListener {
    private boolean m_ROIBBox;

    public BBoxListener(boolean ROI_bBox) {
      m_ROIBBox = ROI_bBox;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
       if (e.getStateChange() == ItemEvent.SELECTED) {
         if (m_ROIBBox) {
           m_ROIBBoxSwitch.update();
           m_ROIBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
         } else {
           m_subVolBBoxSwitch.update();
           m_subVolBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_ALL);
         }
       }
       else if (e.getStateChange() == ItemEvent.DESELECTED) {
         if (m_ROIBBox)
           m_ROIBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
         else
           m_subVolBBoxSwitch.whichChild.setValue(SoSwitch.SO_SWITCH_NONE);
       }
    }
  }

  class ConstraintBoxListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      m_ROIManip.constrained.setValue(e.getStateChange() == ItemEvent.SELECTED);
    }
  }

  class RelativeBoxListener implements ItemListener {
    @Override
    public void itemStateChanged(ItemEvent e) {
      SoROI roi;
      if (!m_ROIManipActivated && !m_subVolManipActivated)
        roi = m_ROI;
      else
        roi = m_ROIManip;

      roi.relative.setValue(e.getStateChange() == ItemEvent.SELECTED);
      if (roi.relative.getValue()) {
        m_ROIBBoxSwitch.update();
        float[] bounds = m_subVolBBoxSwitch.getBBoxBounds();
        m_ROIBBoxSwitch.setTranslation(bounds[0], bounds[1], bounds[2]);
      }
      else
        m_ROIBBoxSwitch.resetTranslation();
    }
  }

  class FlagsBoxListener implements ActionListener {
    JComboBox<String> m_flagsBox;

    public FlagsBoxListener(JComboBox<String> box) {
      m_flagsBox = box;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
      int selectedItem = m_flagsBox.getSelectedIndex();
      SoROI roi;
      if (!m_ROIManipActivated && !m_subVolManipActivated)
        roi = m_ROI;
      else
        roi = m_ROIManip;

      int flags[] = {
          SoROI.FlagsType.SUB_VOLUME.getValue(),
          SoROI.FlagsType.EXCLUSION_BOX.getValue(),
          SoROI.FlagsType.CROSS.getValue(),
          SoROI.FlagsType.CROSS_INVERT.getValue(),
          SoROI.FlagsType.FENCE.getValue()
      };
      roi.flags.setValue(flags[selectedItem]);
    }
  }

  class ResetSubVolListener extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
      if (m_subVolManipActivated)
        m_ROIManip.subVolume.setValue(m_subVolInitSize);
    }
  }

  class ResetROIListener extends MouseAdapter {
    @Override
    public void mousePressed(MouseEvent e) {
      if (m_ROIManipActivated)
        m_ROIManip.box.setValue(m_boxInitSize);
    }
  }
}
