package volumeviz.sample.volumeSkin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbDataType;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.viewercomponents.awt.IViewerExaminer;
import com.openinventor.ldm.nodes.SoTransferFunction;
import com.openinventor.volumeviz.nodes.SoVolumeData;
import com.openinventor.volumeviz.nodes.SoVolumeSkin;

import util.Example;
import util.ViewerComponentsFactory;

public class Main extends Example
{

  private IViewerExaminer myViewer;

  public static void main(String[] args) {
    Main example = new Main();
    example.demoMain("VolumeSkin");
  }

  @Override
  public void start() {
    myViewer = ViewerComponentsFactory.createViewerExaminer();

    //Volume Size
    // Note this is the same (tiny) volume used in the simpleVolume example
    final int dimX = 10;
    final int dimY = 10;
    final int dimZ = 10;

    // Create data :
    // Note: 0 < data[i] < number of entries in the colorMap.
    // If each data value has the same value A the volume will be unicolor
    // with the color described by the Ath entries of the colorMap.
    // This volume data will use every color in the colorMap
    int capacity = dimX * dimY * dimZ;
    ByteBuffer data = ByteBuffer.allocateDirect(capacity);
    data.order(ByteOrder.nativeOrder());
    for (int i = 0; i < capacity; i++) {
      data.put( new Integer(i % 256).byteValue() );
    }

    // Node to hold the volume data
    // In the first call we specify the voxel dimensions and the actual data.
    // In the second call we specify the 3D extent of the volume in modeling coords.
    SoVolumeData pVolData = new SoVolumeData();
    pVolData.data.setValue(new SbVec3i32(dimX, dimY, dimZ), new SbDataType(SbDataType.DataTypes.UNSIGNED_BYTE), data);
    pVolData.extent.setValue(new SbBox3f( -dimX, -dimY, -dimZ, dimX, dimY, dimZ));

    // Use a predefined colorMap with the SoTransferFunction
    SoTransferFunction pTransFunc = new SoTransferFunction();
    pTransFunc.predefColorMap.setValue(SoTransferFunction.PredefColorMaps.STANDARD);

    // Node in charge of drawing the volume
    SoVolumeSkin pVolRender = new SoVolumeSkin();

    SoSeparator root = new SoSeparator();
    { // Assemble the scene graph
      // Note: SoVolumeSkin must appear after the SoVolumeData node.
      root.addChild(pVolData);
      root.addChild(pTransFunc);
      root.addChild(pVolRender);
    }

    // Set up viewer:
    myViewer.setSceneGraph(root);
    myViewer.viewAll();

    final Component component = myViewer.getComponent();
    component.setPreferredSize(new java.awt.Dimension(600, 500));
    setLayout(new BorderLayout());
    add(component);
  }

  @Override
  public void stop()
  {
    myViewer.dispose();
  }
}
