/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#if !defined(OIV_DEPTHPEELING_H)
#define OIV_DEPTHPEELING_H

/**
 * @ingroup TransparencyShaders
 * @file
 * This file contains fonction that should be used to correctly manage transparency in custom shaders.
 *
 * To properly handle transparency, your fragment shader should contains the following function calls:
 *
 *
 * - You should enclose your code in if ( OivDepthPeel(gl_FragCoord.xyz) ) { } condition
 * - You should output your color using OivDepthPeelingOutputColor() method
 * 
 * These methods are accessible by including the <Inventor/oivDepthPeeling_frag.h> header in your shader:
 *
 * Ex:
 *
 * \code
 * //!oiv_include <Inventor/oivDepthPeeling_frag.h>
 *
 * void main()
 * {
 *   if ( OivDepthPeel(gl_FragCoord.xyz) )
 *   {
 *     Vec4 color = vec4(1, 0, 0, 0.5);
 *     OivDepthPeelingOutputColor(color);
 *   }
 * }
 * \endcode
 */

/**
 * This method peels the current fragment.
 * If the fragment must be ignored the method does the discard.
 * The fragments coords must be in screen space (gl_FragCoord.xyz should always be used)
 * 
 * Returns true if the fragment should be shaded.
 */
bool OivDepthPeel(vec3 fragmentCoords);

/**
 * When depth peeling is enabled OivDepthPeelingOutputColor must be
 * called instead of using the gl_FragData[0] since some depth peeling techniques use
 * MRTs (multiple render targets) or premultiply the color by the alpha value (on-the-fly blending for example).
 */
void OivDepthPeelingOutputColor(vec4 color);

/**
 * By default the depth generated by the rasterizer (gl_FragCoord.z) is used but some algorithms may modify the depth
 * in the fragment shader. In theses case gl_FragCoord.z is not valid and thus the user-defined depth coordinate
 * must be explicitly specified
 */
void OivDepthPeelingOutputColor(vec4 color, vec3 coords);

#endif // OIV_DEPTHPEELING_H
