#ifndef OIV_INSTANCING_H
#define OIV_INSTANCING_H

//!oiv_include <Inventor/oivShapeInstanceMatrix.h>

/**
 * @ingroup InventorInstancingShaders
 * @file
 * This file contains fonction to access instancing parameters.
 */

/**
 * Initialize instancing.
 * Must be called when doing instancing.
 */
void OivInstancingInit()
{
}

/**
 * Get the current instance ID when using multiple instance.
 * @return the shape instance ID.
 */
int OivInstanceID()
{
  return OivGetShapeInstanceID();
}

/**
 * Get the translation vector to apply to the current geometry instance.
 * @return the shape instance translation.
 */
vec3 OivInstanceTranslation()
{
  return OivGetShapeInstanceTranslation();
}

/**
 * Get the scale vector to apply to the current geometry instance.
 * @return the shape instance scale.
 */
vec3 OivInstanceScale()
{
  return OivGetShapeInstanceScale();
}

/**
 * Get the rotation (i.e. a quaternion) to apply to the current geometry instance.
 * @return the shape instance rotation
 */
vec4 OivInstanceRotation()
{
  return OivGetShapeInstanceRotation();
}

/**
 * Get the transformation matrix to apply to the current geometry instance, i.e.,
 * the combination of instance rotation, scale and translation.
 * @return the shape instance transformation matrix.
 */
mat4 OivInstanceMatrix()
{
  return OivGetShapeInstanceMatrix();
}

#endif /* OIV_INSTANCING_H */
