#ifndef OIV_SHAPE_ATTRIBUTE_H
#define OIV_SHAPE_ATTRIBUTE_H

//!oiv_include <Inventor/oivShaderStages.h>

#if (OIV_SHADER_STAGE == OIV_VERTEX_SHADER)

/**
 * @ingroup InventorShaders
 * @file
 * This file contains fonction to acces vertex attributes.
 */

/*****************************************************************************/
// Attributes

/**
 * Get the position of the current vertex.
 * @return the position of the current vertex.
 */
vec4 OivVertexPosition()
{
  return gl_Vertex;
}

/**
 * Get the normal of the current vertex.
 * @return the normal of the current vertex.
 */
vec3 OivVertexNormal()
{
  return gl_Normal;
}

/**
 * Get the color of the current vertex.
 * @return the color of the current vertex.
 */
vec4 OivVertexColor()
{
  return gl_Color;
}

/**
 * Get the texture coordinate of the current vertex.
 * @param unit specifies which texture unit between 0 and OivMaxTextureUnit()-1.
 * @return the texture coordinate of the current vertex for a given texture unit.
 */
vec4 OivVertexTextureCoordinate(int unit)
{
  switch (unit)
  {
  default:
  case 0:
    return gl_MultiTexCoord0;
  case 1:
    return gl_MultiTexCoord1;
  case 2:
    return gl_MultiTexCoord2;
  case 3:
    return gl_MultiTexCoord3;
  case 4:
    return gl_MultiTexCoord4;
  case 5:
    return gl_MultiTexCoord5;
  case 6:
    return gl_MultiTexCoord6;
  case 7:
    return gl_MultiTexCoord7;
  }
  return gl_MultiTexCoord0;
}

#endif // OIV_SHADER_STAGE
#endif /* OIV_SHAPE_ATTRIBUTE_H */
