#ifndef OIV_SHAPE_INSTANCE_MATRIX_H
#define OIV_SHAPE_INSTANCE_MATRIX_H

/**
 * @ingroup InventorInstancingShaders
 * @file
 * This file contains utilities fonction when using SoMultipleInstance node.
 */

/**
 * Returns the current instanceID when using multi instancing.
 * see SoShapeInstanceProperty
 */
int OivGetShapeInstanceID();

/**
 * Returns the translation vector to apply to the current geometry instance.
 */
vec3 OivGetShapeInstanceTranslation();

/**
 * Returns the scale vector to apply to the current geometry instance.
 */
vec3 OivGetShapeInstanceScale();

/**
 * Returns the rotation (i.e. a quaternion) to apply to the current geometry
 * instance.
 */
vec4 OivGetShapeInstanceRotation();

/** 
 * Return the curent material according to given color material mode
 * Inventor supports diffuse color material only 
 */
vec4 OivGetDiffuse();

/**
 * Returns the model matrix to apply to the current geometry instance.
 */
mat4 OivGetShapeInstanceMatrix();


/*****************************************************************************/

/**
 * Returns the model matrix to apply to the current geometry vertex.
 * This matrix contains instance and local transformations.
 */
mat4 OivGetModelViewMatrix();

/**
 * Returns the normal matrix to apply to the current geometry normal.
 * This matrix contains instance and local transformations.
 */
mat3 OivGetNormalMatrix();

/**
 * Returns the normal matrix to apply to the current geometry normal
 * with precomputed model view matrix.
 * This matrix contains instance and local transformations.
 */
mat3 OivGetNormalMatrix( in mat4 modelViewMatrix );


#endif // OIV_SHAPE_INSTANCE_MATRIX_H
