/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZ_CLIPPING_FRAG_H
#define VVIZ_CLIPPING_FRAG_H

/**
 * @ingroup VolumeVizFragmentShaders
 * SoVolumeShader::CLIPPING_FUNCTION function.
 *
 * Applications can replace this method to customize the SoVolumeShader::CLIPPING_FUNCTION shader stage. @BR
 *
 * @param tCoord Dataset id
 * @return TRUE if given tCoord should be clipped.
 */
bool VVizIsClipped(vec3 tCoord);

/**
 * @ingroup VolumeVizFragmentShaders
 * @file
 * This file contains function related to clipping feature.
 */

/**
 *  Do clipping when using an SoVolumeClippingGroup or
 *  SoUniformGridClipping node. If no SoUniformGridClipping or SoVolumeClippingGroup nodes are
 *  present in the scene graph, this function will have no effect.
 *
 * Must be called in a custom FRAGMENT_MAIN shader only.
 */
void VVizClipVoxel();

#endif


