/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZCOORDINATES_FRAG_H
#define VVIZCOORDINATES_FRAG_H

/**
 * @ingroup VolumeVizFragmentShaders
 * @file
 * This file function relative to rectilinear coordinate support.
 */

/**
 * Compute new coordinates from input coordinates. @BR
 *
 * This method is used to support rectilinear coordinates or custom projection.
 * It computes voxel coordinates and must be used instead of @I gl_TexCoord[0].xyz@i. 
 * If not used, texture coordinates may not be clamped, scaled, etc... as necessary in 
 * order to have correct rendering.
 * 
 * The parameter usually is @I gl_TexCoord[0].xyz@i (in slicing mode only).
 * The returned coordinate is in general directly passed to @I VVizCombineData@i method.
 *
 * @param dataCoord Coordinates of point, in normalized dataset space.
 * @return Projected coord if requested, returns dataCoord by default.
 */
vec3 VVizComputeCoordinates(const vec3 dataCoord);

#endif


