/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef VVIZFNC_FRAG_H
#define VVIZFNC_FRAG_H

/**
 * @ingroup VolumeVizFragmentShaders
 * @file
 * This file contains various utility method
 */

/**
 * Blend 2 colors using the over operator, result color is not alpha premultiplied.
 * @param underCol First color to blend.
 * @param overCol Second color to blend.
 * @return Blended color.
 */
vec4 VVizOverOperator(vec4 underCol, vec4 overCol);

/**
 * Compute the luminance of a voxel value.
 * @param data value to convert
 * @return Luminance of data.
 */
float VVizGetLuminance(VVIZ_DATATYPE data);

/**
 * Returns virtual coordinates of nearest voxel center, taking
 * in account current voxel resolution. This can be used to avoid having
 * interpolation issues by taking the true value of voxel.
 */
vec3 VVizGetNearestCoord(in VVizVoxelInfo voxelInfo);

/**
 * Returns the gradient at the center of the two slices.
 */
 #if VVIZ_SHAPE_TYPE == VVIZ_VRENDER
vec3 VVizComputePreintegratedGradient(vec3 tcoord0, vec3 tcoord1);
vec3 VVizComputePreintegratedGradient(VVizDataSetId tex, vec3 tcoord0, vec3 tcoord1);
vec3 VVizComputePreintegratedGradient(VVizDataSetId tex, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack);
#endif

/**
 * Returns the current normal.
 */
#if VVIZ_SHAPE_TYPE == VVIZ_VRENDER
vec3 VVizComputeNormal(vec3 view, vec3 grad);
vec3 VVizComputeNormal(vec3 view, vec3 grad, float gradNorm);
#endif

/**
 * Compute normal in surface of 2D shapes (slices, volumeGeometry, volumeSkin, hzighfield) at given
 * coordinates. Normal is returned in eye space. If bump mapping is currently enabled, the normal
 * corresponding to bump effect will be returned.
 */
vec3 VVizComputeNormal(vec3 tcoordVirt);

/**
 *  Returns the color of the lighted pixel belonging to the isosurface. @I sf@i and @I sb@i are usually the volume
 *  data which have the texture coordinate gl_TexCoord[0] and gl_TexCoord[1] computed by
 *  VVizComputeFrontSliceTexCoord and VVizComputeBackSliceTexCoord. If there is no isosurface between @I sf@i and
 *  @I sb@i, a transparent pixel will be returned. Lighting is computed with the first directional light found
 *  in the scene graph. @BR
 *  Because it needs a special texture, this function can only be
 *  used with SoVolumeIsosurface. 
 */
#if VVIZ_SHAPE_TYPE == VVIZ_VRENDER
vec4 VVizComputeIsoMaterial(VVizDataSetId tex, in VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int maskId);
#endif

/**
 *  Convert the volume data values @I (sf, sb)@i to a color by lookup in the pre-integrated table.
 *  The pre-integrated table is a precomputed table which gives an approximation of the volume rendering
 *  integral between two slices. @BR Because it needs a special texture, this function can only be
 *  used with SoVolumeRenderingQuality.
 */
vec4 VVizComputePreIntegrated(VVIZ_DATATYPE sf, VVIZ_DATATYPE sb);
vec4 VVizComputePreIntegrated(VVIZ_DATATYPE sf, VVIZ_DATATYPE sb, int mask);
vec4 VVizComputePreIntegrated(inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int mask);

/**
 * Returns the conversion of the volume data value @I sf@i to color by lookup in the colormap.
 */
vec4 VVizComputeVolumeRendering(VVIZ_DATATYPE sf);
vec4 VVizComputeVolumeRendering(inout VVizVoxelInfo voxelInfoFront, int mask);
vec4 VVizComputeVolumeRendering(VVIZ_DATATYPE sf, int tfId);

vec2 VVizComputeDiffuseAndSpecularCoeffs(vec3 normal, float gradLength, float threshold, vec3 lightVec, vec3 halfVec, float shininess);
vec3 VVizApplySurfaceScalarInternal(vec3 baseColor, vec3 lightedColor, float gradLength);
vec3 VVizApplySurfaceScalar(vec3 baseColor, vec3 lightedColor, float gradLength);

/**
 *  Add lighting to the color @I col@i. 
 * @I col@i is usually the result of VVizComputeVolumeRendering.
 */
vec4 VVizComputeVolumeRenderingLighting(in vec4 col, in vec3 normal, in float gradLength);

/**
 *  Add lighting to the color @I col@i in the case of  pre-integrated rendering.  @I col@i is usually the
 *  result of VVizComputePreintegrated. The difference with the VVizComputeVolumeRenderingLighting function is that
 *  the normal used for lighting is at the middle of the space between the front and the
 *  back slice. Lighting is computed with the first directional light found
 *  in the scene graph.  @BR Because it needs a special texture, this function can only be used
 *  with SoVolumeRenderingQuality. 
 */
vec4 VVizComputePreintegratedLighting(in vec4 col, in vec3 normal, in float gradLength);

/**
 * Returns the current viewing vector.
 */
vec3 VVizComputeViewVec();

// TODO should take datasetInfo or datasetId as input.
bool VVizIsOutsideTexture(in vec3 tcoord);
// TODO should take datasetInfo or datasetId as input.
bool VVizIsOutsideVolume(in vec3 tcoord);

/**True if tcoord is on the volume's boundary voxel or out of the volume*/
// TODO should take datasetInfo or datasetId as input.
bool VVizIsOutsideOrOnVolumeBorder(in vec3 tcoord);

/** Sample texture without converting from virtual to physical texture coords */
VVIZ_DATATYPE VVizGetDataPhysicalLod(sampler3D tex, vec3 tcoord, float lod);

/** Sample texture without converting from virtual to physical texture coords */
VVIZ_DATATYPE VVizGetDataPhysicalLod(sampler2D tex, vec2 tcoord, float lod);

/** 
 * Return depth in screen space (range [0, 1]. 0 is nearClip, 1 is farClip) 
 * of the specified virtual space coordinate. 
 */
float VVizGetProjectedDepth(in vec3 tcoord);

/** 
 * Return screen coordinates (range [0, 1]) of current fragment center. 
 * Note that if using lowResScale the center of the corresponding FULL resolution fragment is returned.
 * This can be useful when using screen space effects (like depth peeling) to retrieve the value of
 * the current fragment. 
 */
vec2 VVizGetScreenCoord();

#if defined(VVIZ_NUM_CLIPPING_PLANES)
bool VVizIsClippedByPlane(in vec3 tcoord);
#endif

/** Return true if alphaValue is considered as fully transparent */
bool VVizIsTransparent(in float alphaValue);

/** Return true if alphaValue is considered as fully opaque */
bool VVizIsOpaque(in float alphaValue);

/** Helper function to fetch a texel at a specific LOD */
vec4 VVizTextureLod(sampler3D tex, vec3 tcoord, float mipLevel);

/** Helper function to fetch a texel at a specific LOD */
vec4 VVizTextureLod(sampler2D tex, vec2 tcoord, float mipLevel);

/** Helper function to fetch a texel at a specific LOD */
vec4 VVizTextureLod(sampler2D tex, vec3 tcoord, float mipLevel);

vec4 VVizGetColor(VVizDataSetId dataset, in vec3 viewVec, in vec3 rayDir, inout VVizVoxelInfo voxel, in VVizVoxelInfo previousVoxel);
void VVizComputeGradientCommon(in vec3 tcoordFront, in vec3 tcoordBack, out vec3 gradient, out vec3 normal);
void VVizComputeGradientCommon(VVizDataSetId dataset, in vec3 tcoordFront, in vec3 tcoordBack, out vec3 gradient, out vec3 normal);

#endif
