package com.openinventor.inventor.viewercomponents.awt;

import java.awt.Component;

import com.openinventor.inventor.actions.SoGLRenderAction;
import com.openinventor.inventor.nodes.SoNode;

/**
 * Interface for basic render area.
 *
 */
public interface IRenderArea
{

  /**
   * Gets the parent component of this render area.
   *
   * @return the parent component
   */
  public Component getComponent();

  /**
   * Sets the scene graph. This is the Open Inventor scene which will be
   * traversed for rendering and event processing.
   *
   * @param sceneGraph
   *          the scene graph
   */
  public void setSceneGraph(SoNode sceneGraph);

  /**
   * Gets the GLRenderAction used for rendering.
   *
   * @return the GLRenderAction used for rendering
   */
  public SoGLRenderAction getGLRenderAction();

  /**
   * Sets the GLRenderAction used for rendering.
   *
   * @param ra
   *          the GLRenderAction used for rendering
   */
  public void setGLRenderAction(SoGLRenderAction ra);

  /**
   * Gets the global transparency algorithm to use when rendering.
   *
   * @return the global transparency algorithm
   */
  public SoGLRenderAction.TransparencyTypes getTransparencyType();

  /**
   * Sets the global transparency algorithm to use when rendering.
   *
   * @param type
   *          the global transparency algorithm
   */
  public void setTransparencyType(SoGLRenderAction.TransparencyTypes type);

  /**
   * Schedules a redraw for some time in the near future.
   */
  public void scheduleRedraw();

  /**
   * Activates or deactivates raw stereo.
   *
   * @param activated
   *          true to activate raw stereo
   */
  public void activateStereo(boolean activated);

  /**
   * Gets availability of raw stereo.
   *
   * @return true if the raw stereo is available
   */
  public boolean isRawStereoAvailable();

  /**
   * Dispose area resources.
   */
  public void dispose();

}
