package com.openinventor.inventor.viewercomponents.awt;

import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

/**
 * Interface for examiner render area.<br>
 * An examiner render area has a {@code SceneExaminer} node as root of the scene
 * graph.
 *
 * @see com.openinventor.inventor.viewercomponents.nodes.SceneExaminer
 *
 */
public interface IRenderAreaExaminer extends IRenderAreaInteractive
{

  @Override
  public SceneExaminer getRootSceneGraph();

  /**
   * Sets the interaction into or out off seek mode (default is off).
   *
   * @param onOrOff
   *          true to activate seek mode
   */
  public void setSeekMode(boolean onOrOff);

  /**
   * Sets the navigation mode to orbit or plane.
   *
   * @param mode
   *          the new navigation mode
   */
  public void setNavigationMode(NavigationMode mode);

  /**
   * Gets the current navigation mode.
   *
   * @return the current navigation mode
   */
  public NavigationMode getNavigationMode();

  /**
   * Set interaction mode to navigation or selection.
   *
   * @param mode
   *          the new interaction mode
   */
  public void setInteractionMode(InteractionMode mode);

  /**
   * Gets the current interaction mode.
   *
   * @return the current interaction mode
   */
  public InteractionMode getInteractionMode();

  /**
   * Adds the specified listener to receive notifications of interaction mode
   * changes.
   *
   * @param listener
   *          the interaction mode listener to add
   */
  public void addInteractionModeListener(InteractionModeListener listener);

  /**
   * Removes the specified listener so that it no longer receives notifications
   * of interaction mode changes.
   *
   * @param listener
   *          the interaction mode listener to remove
   */
  public void removeInteractionModeListener(InteractionModeListener listener);

}
