package com.openinventor.inventor.viewercomponents.awt;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.sensors.SoSystemTimerTask;

/**
 * Implementation of SoSystemTimer with a javax.swing.Timer.
 * <p>
 * This implementation can be used in an AWT or SWING application.
 */
public class Timer extends SoSystemTimer
{

  private javax.swing.Timer m_swingTimer;
  private TimerListener m_timerListener;
  private SoSystemTimerTask m_task;
  private int m_delay;
  private boolean m_isRepeat;

  public Timer()
  {
    m_swingTimer = null;
    m_timerListener = new TimerListener();
    m_task = null;
    m_delay = 0;
    m_isRepeat = false;
  }

  @Override
  public void start()
  {
    if ( m_swingTimer != null )
      m_swingTimer.stop();
    m_swingTimer = new javax.swing.Timer(m_delay, m_timerListener);
    m_swingTimer.setRepeats(m_isRepeat);
    m_swingTimer.start();
  }

  @Override
  public void stop()
  {
    if ( m_swingTimer != null )
      m_swingTimer.stop();
  }

  @Override
  public void setDelay(int time)
  {
    m_delay = time;
  }

  @Override
  public boolean isPending()
  {
    if ( m_swingTimer != null )
      return m_swingTimer.isRunning();
    return false;
  }

  @Override
  public void setRepeat(boolean flag)
  {
    m_isRepeat = flag;
  }

  @Override
  public void setTask(SoSystemTimerTask task)
  {
    m_task = task;
  }

  private class TimerListener implements ActionListener
  {
    @Override
    public void actionPerformed(ActionEvent e)
    {
      if ( m_task != null )
        m_task.run();
    }
  }

}
