package com.openinventor.inventor.viewercomponents.awt.glcanvas.renderareas;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;

import com.jogamp.opengl.GLCapabilities;
import javax.swing.ImageIcon;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.awt.IRenderAreaExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

public class RenderAreaExaminer extends RenderAreaInteractive implements IRenderAreaExaminer
{
  private static final Cursor SEEK_CURSOR =
      createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorSeek.png", "seek cursor");
  private static final Cursor VIEWING_CURSOR =
      createCursor("/com/openinventor/inventor/viewercomponents/icons/CursorCurvedHand.png", "hand cursor");

  private SceneExaminer m_examinerRootSceneGraph;

  public RenderAreaExaminer()
  {
    super(false);

    init();
  }

  public RenderAreaExaminer(GLCapabilities caps)
  {
    super(false, caps);

    init();
  }

  private void init()
  {
    // Disable SceneExaminer automatic adjustment of clipping planes,
    // adjustment is managed by the render area.
    SoPreferences.setValue("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", "false");
    m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();

    buildSceneGraph();

    updateInteractionCursor();
    m_examinerRootSceneGraph.addInteractionModeListener(new InteractionModeListener()
    {
      @Override
      public void seekModeChanged(boolean onOrOff)
      {
        updateSeekCursor(onOrOff);
      }

      @Override
      public void interactionModeChanged(InteractionMode newMode)
      {
        updateInteractionCursor();
      }
    });
  }

  @Override
  public void setSeekMode(boolean onOrOff)
  {
    m_examinerRootSceneGraph.setSeekMode(onOrOff);
  }

  @Override
  public void setNavigationMode(NavigationMode mode)
  {
    m_examinerRootSceneGraph.setNavigationMode(mode);
  }

  @Override
  public NavigationMode getNavigationMode()
  {
    return m_examinerRootSceneGraph.getNavigationMode();
  }

  @Override
  public void setInteractionMode(InteractionMode mode)
  {
    m_examinerRootSceneGraph.setInteractionMode(mode);
  }

  @Override
  public InteractionMode getInteractionMode()
  {
    return m_examinerRootSceneGraph.getInteractionMode();
  }

  @Override
  public void addInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.addInteractionModeListener(listener);
  }

  @Override
  public void removeInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.removeInteractionModeListener(listener);
  }

  @Override
  public SceneExaminer getRootSceneGraph()
  {
    return m_examinerRootSceneGraph;
  }

  private void updateSeekCursor(boolean seek)
  {
    if ( seek )
      setCursor(SEEK_CURSOR);
    else
      updateInteractionCursor();
  }

  private void updateInteractionCursor()
  {
    if ( getInteractionMode() == InteractionMode.NAVIGATION )
      setCursor(VIEWING_CURSOR);
    else
      setCursor(Cursor.getDefaultCursor());
  }

  private static Cursor createCursor(String resourceName, String cursorName)
  {
    return Toolkit.getDefaultToolkit().createCustomCursor(
        new ImageIcon(RenderAreaExaminer.class.getResource(resourceName)).getImage(), new Point(16, 16), cursorName);
  }

}
