package com.openinventor.inventor.viewercomponents.awt.newt.renderareas;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.InputEvent;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;

public class NewtEventToSoEvent
{

  private static Hashtable<Short, SoKeyboardEvent.Keys> newt2OivKey = null;

  private static SoKeyboardEvent.Keys getKeySym(short key)
  {
    if ( newt2OivKey == null )
    {
      newt2OivKey = new Hashtable<Short, SoKeyboardEvent.Keys>();

      // @formatter:off
      Object array[] = {
        com.jogamp.newt.event.KeyEvent.VK_UNDEFINED, SoKeyboardEvent.Keys.ANY,
        com.jogamp.newt.event.KeyEvent.VK_SHIFT, SoKeyboardEvent.Keys.LEFT_SHIFT,
        com.jogamp.newt.event.KeyEvent.VK_CONTROL, SoKeyboardEvent.Keys.LEFT_CONTROL,
        com.jogamp.newt.event.KeyEvent.VK_ALT, SoKeyboardEvent.Keys.LEFT_ALT,
        com.jogamp.newt.event.KeyEvent.VK_0, SoKeyboardEvent.Keys.NUMBER_0,
        com.jogamp.newt.event.KeyEvent.VK_1, SoKeyboardEvent.Keys.NUMBER_1,
        com.jogamp.newt.event.KeyEvent.VK_2, SoKeyboardEvent.Keys.NUMBER_2,
        com.jogamp.newt.event.KeyEvent.VK_3, SoKeyboardEvent.Keys.NUMBER_3,
        com.jogamp.newt.event.KeyEvent.VK_4, SoKeyboardEvent.Keys.NUMBER_4,
        com.jogamp.newt.event.KeyEvent.VK_5, SoKeyboardEvent.Keys.NUMBER_5,
        com.jogamp.newt.event.KeyEvent.VK_6, SoKeyboardEvent.Keys.NUMBER_6,
        com.jogamp.newt.event.KeyEvent.VK_7, SoKeyboardEvent.Keys.NUMBER_7,
        com.jogamp.newt.event.KeyEvent.VK_8, SoKeyboardEvent.Keys.NUMBER_8,
        com.jogamp.newt.event.KeyEvent.VK_9, SoKeyboardEvent.Keys.NUMBER_9,
        com.jogamp.newt.event.KeyEvent.VK_A, SoKeyboardEvent.Keys.A,
        com.jogamp.newt.event.KeyEvent.VK_B, SoKeyboardEvent.Keys.B,
        com.jogamp.newt.event.KeyEvent.VK_C, SoKeyboardEvent.Keys.C,
        com.jogamp.newt.event.KeyEvent.VK_D, SoKeyboardEvent.Keys.D,
        com.jogamp.newt.event.KeyEvent.VK_E, SoKeyboardEvent.Keys.E,
        com.jogamp.newt.event.KeyEvent.VK_F, SoKeyboardEvent.Keys.F,
        com.jogamp.newt.event.KeyEvent.VK_G, SoKeyboardEvent.Keys.G,
        com.jogamp.newt.event.KeyEvent.VK_H, SoKeyboardEvent.Keys.H,
        com.jogamp.newt.event.KeyEvent.VK_I, SoKeyboardEvent.Keys.I,
        com.jogamp.newt.event.KeyEvent.VK_J, SoKeyboardEvent.Keys.J,
        com.jogamp.newt.event.KeyEvent.VK_K, SoKeyboardEvent.Keys.K,
        com.jogamp.newt.event.KeyEvent.VK_L, SoKeyboardEvent.Keys.L,
        com.jogamp.newt.event.KeyEvent.VK_M, SoKeyboardEvent.Keys.M,
        com.jogamp.newt.event.KeyEvent.VK_N, SoKeyboardEvent.Keys.N,
        com.jogamp.newt.event.KeyEvent.VK_O, SoKeyboardEvent.Keys.O,
        com.jogamp.newt.event.KeyEvent.VK_P, SoKeyboardEvent.Keys.P,
        com.jogamp.newt.event.KeyEvent.VK_Q, SoKeyboardEvent.Keys.Q,
        com.jogamp.newt.event.KeyEvent.VK_R, SoKeyboardEvent.Keys.R,
        com.jogamp.newt.event.KeyEvent.VK_S, SoKeyboardEvent.Keys.S,
        com.jogamp.newt.event.KeyEvent.VK_T, SoKeyboardEvent.Keys.T,
        com.jogamp.newt.event.KeyEvent.VK_U, SoKeyboardEvent.Keys.U,
        com.jogamp.newt.event.KeyEvent.VK_V, SoKeyboardEvent.Keys.V,
        com.jogamp.newt.event.KeyEvent.VK_W, SoKeyboardEvent.Keys.W,
        com.jogamp.newt.event.KeyEvent.VK_X, SoKeyboardEvent.Keys.X,
        com.jogamp.newt.event.KeyEvent.VK_Y, SoKeyboardEvent.Keys.Y,
        com.jogamp.newt.event.KeyEvent.VK_Z, SoKeyboardEvent.Keys.Z,
        com.jogamp.newt.event.KeyEvent.VK_HOME, SoKeyboardEvent.Keys.HOME,
        com.jogamp.newt.event.KeyEvent.VK_LEFT, SoKeyboardEvent.Keys.LEFT_ARROW,
        com.jogamp.newt.event.KeyEvent.VK_UP, SoKeyboardEvent.Keys.UP_ARROW,
        com.jogamp.newt.event.KeyEvent.VK_RIGHT, SoKeyboardEvent.Keys.RIGHT_ARROW,
        com.jogamp.newt.event.KeyEvent.VK_DOWN, SoKeyboardEvent.Keys.DOWN_ARROW,
        com.jogamp.newt.event.KeyEvent.VK_PAGE_UP, SoKeyboardEvent.Keys.PAGE_UP,
        com.jogamp.newt.event.KeyEvent.VK_PAGE_DOWN, SoKeyboardEvent.Keys.PAGE_DOWN,
        com.jogamp.newt.event.KeyEvent.VK_META, SoKeyboardEvent.Keys.LEFT_META,
        com.jogamp.newt.event.KeyEvent.VK_END, SoKeyboardEvent.Keys.END,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD0, SoKeyboardEvent.Keys.PAD_0,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD1, SoKeyboardEvent.Keys.PAD_1,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD2, SoKeyboardEvent.Keys.PAD_2,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD3, SoKeyboardEvent.Keys.PAD_3,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD4, SoKeyboardEvent.Keys.PAD_4,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD5, SoKeyboardEvent.Keys.PAD_5,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD6, SoKeyboardEvent.Keys.PAD_6,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD7, SoKeyboardEvent.Keys.PAD_7,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD8, SoKeyboardEvent.Keys.PAD_8,
        com.jogamp.newt.event.KeyEvent.VK_NUMPAD9, SoKeyboardEvent.Keys.PAD_9,
        com.jogamp.newt.event.KeyEvent.VK_ADD, SoKeyboardEvent.Keys.PAD_ADD,
        com.jogamp.newt.event.KeyEvent.VK_SUBTRACT, SoKeyboardEvent.Keys.PAD_SUBTRACT,
        com.jogamp.newt.event.KeyEvent.VK_MULTIPLY, SoKeyboardEvent.Keys.PAD_MULTIPLY,
        com.jogamp.newt.event.KeyEvent.VK_DIVIDE, SoKeyboardEvent.Keys.PAD_DIVIDE,
        com.jogamp.newt.event.KeyEvent.VK_F1, SoKeyboardEvent.Keys.F1,
        com.jogamp.newt.event.KeyEvent.VK_F2, SoKeyboardEvent.Keys.F2,
        com.jogamp.newt.event.KeyEvent.VK_F3, SoKeyboardEvent.Keys.F3,
        com.jogamp.newt.event.KeyEvent.VK_F4, SoKeyboardEvent.Keys.F4,
        com.jogamp.newt.event.KeyEvent.VK_F5, SoKeyboardEvent.Keys.F5,
        com.jogamp.newt.event.KeyEvent.VK_F6, SoKeyboardEvent.Keys.F6,
        com.jogamp.newt.event.KeyEvent.VK_F7, SoKeyboardEvent.Keys.F7,
        com.jogamp.newt.event.KeyEvent.VK_F8, SoKeyboardEvent.Keys.F8,
        com.jogamp.newt.event.KeyEvent.VK_F9, SoKeyboardEvent.Keys.F9,
        com.jogamp.newt.event.KeyEvent.VK_F10, SoKeyboardEvent.Keys.F10,
        com.jogamp.newt.event.KeyEvent.VK_F11, SoKeyboardEvent.Keys.F11,
        com.jogamp.newt.event.KeyEvent.VK_F12, SoKeyboardEvent.Keys.F12,
        com.jogamp.newt.event.KeyEvent.VK_BACK_SPACE, SoKeyboardEvent.Keys.BACKSPACE,
        com.jogamp.newt.event.KeyEvent.VK_TAB, SoKeyboardEvent.Keys.TAB,
        com.jogamp.newt.event.KeyEvent.VK_ENTER, SoKeyboardEvent.Keys.ENTER,
        com.jogamp.newt.event.KeyEvent.VK_PAUSE, SoKeyboardEvent.Keys.PAUSE,
        com.jogamp.newt.event.KeyEvent.VK_SCROLL_LOCK, SoKeyboardEvent.Keys.SCROLL_LOCK,
        com.jogamp.newt.event.KeyEvent.VK_ESCAPE, SoKeyboardEvent.Keys.ESCAPE,
        com.jogamp.newt.event.KeyEvent.VK_DELETE, SoKeyboardEvent.Keys.KEY_DELETE,
        com.jogamp.newt.event.KeyEvent.VK_PRINTSCREEN, SoKeyboardEvent.Keys.PRINT,
        com.jogamp.newt.event.KeyEvent.VK_INSERT, SoKeyboardEvent.Keys.INSERT,
        com.jogamp.newt.event.KeyEvent.VK_NUM_LOCK, SoKeyboardEvent.Keys.NUM_LOCK,
        com.jogamp.newt.event.KeyEvent.VK_CAPS_LOCK, SoKeyboardEvent.Keys.CAPS_LOCK,
        com.jogamp.newt.event.KeyEvent.VK_SPACE, SoKeyboardEvent.Keys.SPACE,
        com.jogamp.newt.event.KeyEvent.VK_QUOTE, SoKeyboardEvent.Keys.APOSTROPHE,
        com.jogamp.newt.event.KeyEvent.VK_COMMA, SoKeyboardEvent.Keys.COMMA,
        com.jogamp.newt.event.KeyEvent.VK_PERIOD, SoKeyboardEvent.Keys.PERIOD,
        com.jogamp.newt.event.KeyEvent.VK_SLASH, SoKeyboardEvent.Keys.SLASH,
        com.jogamp.newt.event.KeyEvent.VK_SEMICOLON, SoKeyboardEvent.Keys.SEMICOLON,
        com.jogamp.newt.event.KeyEvent.VK_EQUALS, SoKeyboardEvent.Keys.EQUAL,
        com.jogamp.newt.event.KeyEvent.VK_OPEN_BRACKET, SoKeyboardEvent.Keys.BRACKETLEFT,
        com.jogamp.newt.event.KeyEvent.VK_BACK_SLASH, SoKeyboardEvent.Keys.BACKSLASH,
        com.jogamp.newt.event.KeyEvent.VK_CLOSE_BRACKET, SoKeyboardEvent.Keys.BRACKETRIGHT,
        com.jogamp.newt.event.KeyEvent.VK_BACK_QUOTE, SoKeyboardEvent.Keys.GRAVE};
      // @formatter:on

      for ( int i = 0; i < array.length; i += 2 )
        newt2OivKey.put((Short) array[i], (SoKeyboardEvent.Keys) array[i + 1]);

      // On macOS, the CTRL value corresponds to the META key on the keyboard,
      // and the META value corresponds to the CTRL key.
      if ( System.getProperty("os.name").toLowerCase().contains("mac") )
      {
        newt2OivKey.put((Short)com.jogamp.newt.event.KeyEvent.VK_CONTROL, SoKeyboardEvent.Keys.LEFT_META);
        newt2OivKey.put((Short)com.jogamp.newt.event.KeyEvent.VK_META, SoKeyboardEvent.Keys.LEFT_CONTROL);
      }

    }

    SoKeyboardEvent.Keys oivKey = newt2OivKey.get(key);
    if ( oivKey == null )
      return SoKeyboardEvent.Keys.ANY;

    return oivKey;
  }

  private static SoEventBuilder s_ivEvent = new SoEventBuilder();

  private static boolean isControlDown(InputEvent event)
  {
    // On macOS, the CTRL value corresponds to the META key on the keyboard,
    // and the META value corresponds to the CTRL key.
    if ( System.getProperty("os.name").toLowerCase().contains("mac") )
      return event.isMetaDown();
    else
      return event.isControlDown();
  }

  public static SoMouseButtonEvent getMousePressEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMousePressEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMouseReleaseEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent event, Component source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (awt) to lower (oiv)
    int y = source.getSize().height - 1 - event.getY();

    return s_ivEvent.getMouseDoubleClickEvent(event.getX(), y, whichButton, event.isAltDown(), isControlDown(event),
        event.isShiftDown());
  }

  private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent event)
  {
    SoMouseButtonEvent.Buttons whichButton;
    int button = event.getButton();
    switch ( button )
    {
    case com.jogamp.newt.event.MouseEvent.BUTTON1 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON1;
      break;
    case com.jogamp.newt.event.MouseEvent.BUTTON2 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON2;
      break;
    case com.jogamp.newt.event.MouseEvent.BUTTON3 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON3;
      break;

    default:
      whichButton = SoMouseButtonEvent.Buttons.ANY;
      break;
    }

    return whichButton;
  }

  public static SoMouseWheelEvent getMouseWheelEvent(MouseEvent event, Component source)
  {
    // get the number of "clicks" the mouse wheel was rotated
    // positive values if the mouse wheel was rotated up/away from the user, and
    // negative values if the mouse wheel was rotated down/towards the user
    int nbClicks;
    if ( event.isShiftDown() )
      nbClicks = (int) event.getRotation()[0];
    else
      nbClicks = (int) event.getRotation()[1];

    // set the mouse wheel delta in OIV event.
    // The values are specified in multiples of the wheel delta.
    int delta = nbClicks * SoPreferences.getInteger("OIV_WHEEL_DELTA", 120);

    return s_ivEvent.getMouseWheelEvent(delta, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseMoveEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseMoveEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseEnterEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseEnterEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoLocation2Event getMouseLeaveEvent(MouseEvent event, Component source)
  {
    // change origin from upper corner (awt) to lower (oiv)
    Dimension dim = source.getSize();
    int y = dim.height - 1 - event.getY();

    return s_ivEvent.getMouseLeaveEvent(event.getX(), y, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoKeyboardEvent getKeyPressEvent(KeyEvent event, Component source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.getKeySymbol());

    return s_ivEvent.getKeyPressEvent(whichKey, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

  public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent event, Component source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.getKeySymbol());

    return s_ivEvent.getKeyReleaseEvent(whichKey, event.isAltDown(), isControlDown(event), event.isShiftDown());
  }

}
