package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import com.jogamp.opengl.GLCapabilities;

import org.eclipse.swt.widgets.Composite;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionMode;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.InteractionModeListener;
import com.openinventor.inventor.viewercomponents.nodes.SceneExaminer.NavigationMode;

public class RenderAreaExaminer extends RenderAreaInteractive
{

  private SceneExaminer m_examinerRootSceneGraph;

  public RenderAreaExaminer(Composite parent, int style)
  {
    super(parent, style, false);

    init();
  }

  public RenderAreaExaminer(Composite parent, int style, GLCapabilities caps)
  {
    super(parent, style, false, caps);

    init();
  }

  private void init()
  {
    // Disable SceneExaminer automatic adjustment of clipping planes,
    // adjustment is managed by the render area.
    SoPreferences.setValue("OIV_SCENE_EXAMINER_AUTO_CLIPPING_PLANES", "false");
    m_rootSceneGraph = m_examinerRootSceneGraph = new SceneExaminer();

    buildSceneGraph();
  }

  public void setSeekMode(boolean onOrOff)
  {
    m_examinerRootSceneGraph.setSeekMode(onOrOff);
  }

  public void setNavigationMode(NavigationMode mode)
  {
    m_examinerRootSceneGraph.setNavigationMode(mode);
  }

  public NavigationMode getNavigationMode()
  {
    return m_examinerRootSceneGraph.getNavigationMode();
  }

  public InteractionMode getInteractionMode()
  {
    return m_examinerRootSceneGraph.getInteractionMode();
  }

  public void addInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.addInteractionModeListener(listener);
  }

  public void removeInteractionModeListener(InteractionModeListener listener)
  {
    m_examinerRootSceneGraph.removeInteractionModeListener(listener);
  }

  @Override
  public SceneExaminer getRootSceneGraph()
  {
    return m_examinerRootSceneGraph;
  }

}
