package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import java.util.Hashtable;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Composite;

import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.viewercomponents.SoEventBuilder;

public class SWTEventToSoEvent
{
  private static Hashtable<Integer, SoKeyboardEvent.Keys> swt2OivKey = null;

  private static SoKeyboardEvent.Keys getKeySym(int key)
  {
    if ( swt2OivKey == null )
    {
      swt2OivKey = new Hashtable<Integer, SoKeyboardEvent.Keys>();

      // @formatter:off
      Object array[] = {
          SWT.SHIFT, SoKeyboardEvent.Keys.LEFT_SHIFT,
          SWT.CONTROL, SoKeyboardEvent.Keys.LEFT_CONTROL,
          SWT.ALT, SoKeyboardEvent.Keys.LEFT_ALT,
          0x030, SoKeyboardEvent.Keys.NUMBER_0,
          0x031, SoKeyboardEvent.Keys.NUMBER_1,
          0x032, SoKeyboardEvent.Keys.NUMBER_2,
          0x033, SoKeyboardEvent.Keys.NUMBER_3,
          0x034, SoKeyboardEvent.Keys.NUMBER_4,
          0x035, SoKeyboardEvent.Keys.NUMBER_5,
          0x036, SoKeyboardEvent.Keys.NUMBER_6,
          0x037, SoKeyboardEvent.Keys.NUMBER_7,
          0x038, SoKeyboardEvent.Keys.NUMBER_8,
          0x039, SoKeyboardEvent.Keys.NUMBER_9,
          0x061, SoKeyboardEvent.Keys.A,
          0x062, SoKeyboardEvent.Keys.B,
          0x063, SoKeyboardEvent.Keys.C,
          0x064, SoKeyboardEvent.Keys.D,
          0x065, SoKeyboardEvent.Keys.E,
          0x066, SoKeyboardEvent.Keys.F,
          0x067, SoKeyboardEvent.Keys.G,
          0x068, SoKeyboardEvent.Keys.H,
          0x069, SoKeyboardEvent.Keys.I,
          0x06A, SoKeyboardEvent.Keys.J,
          0x06B, SoKeyboardEvent.Keys.K,
          0x06C, SoKeyboardEvent.Keys.L,
          0x06D, SoKeyboardEvent.Keys.M,
          0x06E, SoKeyboardEvent.Keys.N,
          0x06F, SoKeyboardEvent.Keys.O,
          0x070, SoKeyboardEvent.Keys.P,
          0x071, SoKeyboardEvent.Keys.Q,
          0x072, SoKeyboardEvent.Keys.R,
          0x073, SoKeyboardEvent.Keys.S,
          0x074, SoKeyboardEvent.Keys.T,
          0x075, SoKeyboardEvent.Keys.U,
          0x076, SoKeyboardEvent.Keys.V,
          0x077, SoKeyboardEvent.Keys.W,
          0x078, SoKeyboardEvent.Keys.X,
          0x079, SoKeyboardEvent.Keys.Y,
          0x07A, SoKeyboardEvent.Keys.Z,
          SWT.HOME, SoKeyboardEvent.Keys.HOME,
          SWT.ARROW_LEFT, SoKeyboardEvent.Keys.LEFT_ARROW,
          SWT.ARROW_UP, SoKeyboardEvent.Keys.UP_ARROW,
          SWT.ARROW_RIGHT, SoKeyboardEvent.Keys.RIGHT_ARROW,
          SWT.ARROW_DOWN, SoKeyboardEvent.Keys.DOWN_ARROW,
          SWT.PAGE_UP, SoKeyboardEvent.Keys.PAGE_UP,
          SWT.PAGE_DOWN, SoKeyboardEvent.Keys.PAGE_DOWN,
          0xFF55, SoKeyboardEvent.Keys.PRIOR,
          SWT.END, SoKeyboardEvent.Keys.END,
          SWT.KEYPAD_0, SoKeyboardEvent.Keys.PAD_0,
          SWT.KEYPAD_1, SoKeyboardEvent.Keys.PAD_1,
          SWT.KEYPAD_2, SoKeyboardEvent.Keys.PAD_2,
          SWT.KEYPAD_3, SoKeyboardEvent.Keys.PAD_3,
          SWT.KEYPAD_4, SoKeyboardEvent.Keys.PAD_4,
          SWT.KEYPAD_5, SoKeyboardEvent.Keys.PAD_5,
          SWT.KEYPAD_6, SoKeyboardEvent.Keys.PAD_6,
          SWT.KEYPAD_7, SoKeyboardEvent.Keys.PAD_7,
          SWT.KEYPAD_8, SoKeyboardEvent.Keys.PAD_8,
          SWT.KEYPAD_9, SoKeyboardEvent.Keys.PAD_9,
          SWT.KEYPAD_ADD, SoKeyboardEvent.Keys.PAD_ADD,
          SWT.KEYPAD_SUBTRACT, SoKeyboardEvent.Keys.PAD_SUBTRACT,
          SWT.KEYPAD_MULTIPLY, SoKeyboardEvent.Keys.PAD_MULTIPLY,
          SWT.KEYPAD_DIVIDE, SoKeyboardEvent.Keys.PAD_DIVIDE,
          SWT.KEYPAD_CR, SoKeyboardEvent.Keys.PAD_ENTER,
          SWT.F1, SoKeyboardEvent.Keys.F1,
          SWT.F2, SoKeyboardEvent.Keys.F2,
          SWT.F3, SoKeyboardEvent.Keys.F3,
          SWT.F4, SoKeyboardEvent.Keys.F4,
          SWT.F5, SoKeyboardEvent.Keys.F5,
          SWT.F6, SoKeyboardEvent.Keys.F6,
          SWT.F7, SoKeyboardEvent.Keys.F7,
          SWT.F8, SoKeyboardEvent.Keys.F8,
          SWT.F9, SoKeyboardEvent.Keys.F9,
          SWT.F10, SoKeyboardEvent.Keys.F10,
          SWT.F11, SoKeyboardEvent.Keys.F11,
          SWT.F12, SoKeyboardEvent.Keys.F12,
          0x008, SoKeyboardEvent.Keys.BACKSPACE,
          0x009, SoKeyboardEvent.Keys.TAB,
          0x00D, SoKeyboardEvent.Keys.ENTER,
          SWT.PAUSE, SoKeyboardEvent.Keys.PAUSE,
          SWT.SCROLL_LOCK, SoKeyboardEvent.Keys.SCROLL_LOCK,
          0x01B, SoKeyboardEvent.Keys.ESCAPE,
          0x07F, SoKeyboardEvent.Keys.KEY_DELETE,
          SWT.PRINT_SCREEN, SoKeyboardEvent.Keys.PRINT,
          SWT.INSERT, SoKeyboardEvent.Keys.INSERT,
          SWT.NUM_LOCK, SoKeyboardEvent.Keys.NUM_LOCK,
          SWT.CAPS_LOCK, SoKeyboardEvent.Keys.CAPS_LOCK,
          0x020, SoKeyboardEvent.Keys.SPACE,
          0x027, SoKeyboardEvent.Keys.APOSTROPHE,
          0x02C, SoKeyboardEvent.Keys.COMMA,
          0x02E, SoKeyboardEvent.Keys.PERIOD,
          0x02F, SoKeyboardEvent.Keys.SLASH,
          0x03B, SoKeyboardEvent.Keys.SEMICOLON,
          0x03D, SoKeyboardEvent.Keys.EQUAL,
          0x05B, SoKeyboardEvent.Keys.BRACKETLEFT,
          0x05C, SoKeyboardEvent.Keys.BACKSLASH,
          0x05D, SoKeyboardEvent.Keys.BRACKETRIGHT,
          0x060, SoKeyboardEvent.Keys.GRAVE
      };
      // @formatter:on

      for ( int i = 0; i < array.length; i += 2 )
        swt2OivKey.put((Integer) array[i], (SoKeyboardEvent.Keys) array[i + 1]);
    }

    SoKeyboardEvent.Keys oivKey = swt2OivKey.get(key);
    if ( oivKey == null )
      return SoKeyboardEvent.Keys.ANY;

    return oivKey;
  }

  private static SoEventBuilder s_ivEvent = new SoEventBuilder();

  public static SoMouseButtonEvent getMousePressEvent(MouseEvent event, Composite source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMousePressEvent(event.x, y, whichButton, isAltDown(event), isCtrlDown(event),
        isShiftDown(event));
  }

  public static SoMouseButtonEvent getMouseReleaseEvent(MouseEvent event, Composite source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMouseReleaseEvent(event.x, y, whichButton, isAltDown(event), isCtrlDown(event),
        isShiftDown(event));
  }

  public static SoMouseButtonEvent getMouseDoubleClickEvent(MouseEvent event, Composite source)
  {
    SoMouseButtonEvent.Buttons whichButton = getButtonId(event);

    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMouseDoubleClickEvent(event.x, y, whichButton, isAltDown(event), isCtrlDown(event),
        isShiftDown(event));
  }

  public static SoMouseWheelEvent getMouseWheelEvent(MouseEvent event, Composite source)
  {
    // get the number of "clicks" the mouse wheel was rotated
    // positive values if the mouse wheel was rotated up/away from the user, and
    // negative values if the mouse wheel was rotated down/towards the user
    int nbClicks = event.count;

    // set the mouse wheel delta in OIV event.
    // The values are specified in multiples of the wheel delta.
    int delta = nbClicks * SoPreferences.getInteger("OIV_WHEEL_DELTA", 120);

    return s_ivEvent.getMouseWheelEvent(delta, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  public static SoLocation2Event getMouseMoveEvent(MouseEvent event, Composite source)
  {
    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMouseMoveEvent(event.x, y, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  public static SoLocation2Event getMouseEnterEvent(MouseEvent event, Composite source)
  {
    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMouseEnterEvent(event.x, y, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  public static SoLocation2Event getMouseLeaveEvent(MouseEvent event, Composite source)
  {
    // change origin from upper corner (swt) to lower (oiv)
    int y = source.getSize().y - 1 - event.y;

    return s_ivEvent.getMouseLeaveEvent(event.x, y, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  private static SoMouseButtonEvent.Buttons getButtonId(MouseEvent event)
  {
    SoMouseButtonEvent.Buttons whichButton;

    switch ( event.button )
    {
    case 1 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON1;
      break;
    case 2 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON2;
      break;
    case 3 :
      whichButton = SoMouseButtonEvent.Buttons.BUTTON3;
      break;

    default:
      whichButton = SoMouseButtonEvent.Buttons.ANY;
      break;
    }

    return whichButton;
  }

  private static boolean isAltDown(MouseEvent mouseEvent)
  {
    return (mouseEvent.stateMask & SWT.ALT) != 0;
  }

  private static boolean isShiftDown(MouseEvent mouseEvent)
  {
    return (mouseEvent.stateMask & SWT.SHIFT) != 0;
  }

  private static boolean isCtrlDown(MouseEvent mouseEvent)
  {
    return (mouseEvent.stateMask & SWT.CTRL) != 0;
  }

  public static SoKeyboardEvent getKeyPressEvent(KeyEvent event, Composite source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.keyCode);

    return s_ivEvent.getKeyPressEvent(whichKey, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  public static SoKeyboardEvent getKeyReleaseEvent(KeyEvent event, Composite source)
  {
    SoKeyboardEvent.Keys whichKey = getKeySym(event.keyCode);

    return s_ivEvent.getKeyReleaseEvent(whichKey, isAltDown(event), isCtrlDown(event), isShiftDown(event));
  }

  private static boolean isAltDown(KeyEvent keyEvent)
  {
    return (keyEvent.stateMask & SWT.ALT) != 0;
  }

  private static boolean isShiftDown(KeyEvent keyEvent)
  {
    return (keyEvent.stateMask & SWT.SHIFT) != 0;
  }

  private static boolean isCtrlDown(KeyEvent keyEvent)
  {
    return (keyEvent.stateMask & SWT.CTRL) != 0;
  }
}
