Thermo Fisher Scientific Products
=================================


__Open Inventor SDK - Headless__

2025.2.1.0.Release.526c276fe8213f27d56fbc846fffcb84b4151833

This package provides an implementation of Open Inventor specifically for
"headless " server machines.  It uses the EGL library, allowing Open Inventor
applications to run without starting an X Server (X11). For example, in a Docker
based environment.

In order to use this package in your project, the following *macro* must be
defined: `OIV_HEADLESS`.

Compared to the desktop package, this package has some limitations:

* No viewers are provided.
  RemoteViz must be used.
* DialogViz extension is not provided.
* A Docker example has been added.
  Please see Example section for more details.

If you do not have a headless usage of Open Inventor, the desktop package is
available [here](https://developer.openinventor.com/index.php/download-pages/open-inventor-2025-2-download-page/).

Installation
------------

The https://developer.openinventor.com/index.php/installation-verification/open-inventor-2025-2/
page contains all informations on the installation process of Open Inventor.


Documentation
-------------

Documentation files are in the doc subdirectory of the Open Inventor
installation directory. Most of these files require a web browser to be
read.

You can read on-line documentation about this product by opening the
following file from within your browser:

`<Your_OIV_SDK_installation_directory>/OpenInventorDeveloperZone.html`

There you will find the reference manual, the user's guide, release notes,
compatibility notes, fixed bugs lists, performance tips, FAQs,
installation instructions and much more.


Example
-------

### How to use this version of Open Inventor with Docker

Our Docker image is based on NVIDIA's *OpenGL Ubuntu 18.04* image, please follow
the specific installation process available
[here](https://docs.nvidia.com/datacenter/cloud-native/container-toolkit/install-guide.html#docker).

### Build the Docker image

The Dockerfile is already included in your copy of Open Inventor, please run the
following command at the root of your install directory:

`docker build -t openinventor/headless .`

*Please note that the password.dat included in the License folder needs to be
replaced by your own password.dat file. DO NOT push the built Docker image on
public Docker registries, as anyone will be able to access your license file.*

### Run the Docker image

Once built, the image can be run with the following command:

`docker run --gpus all -p 8080:8080 openinventor/headless`

Once started, you can access the running demo using the HTML client available in
the **examples/source/RemoteViz/HelloCone/Clients/HTML5/** directory.

*Please note that the RemoteViz Service IP in the index.html file needs to be
modified if Docker is not running on localhost.*

### Notice about texts and fonts

If your RemoteViz service is using nodes displaying text (e.g: SoFont, SoText2, etc. ):
You have to modify your Dockerfile to install any required fonts, as none are
included in NVIDIA's *OpenGL Ubuntu 18.04* image.

Licensing
---------

Open Inventor is protected by a license mechanism limiting its usage to
specified computers or network environments based on commercial agreements.
The licensing section in https://developer.openinventor.com explains
how to setup the licensing for the different use cases.

Temporary licenses can be sent for evaluation purpose. These licenses are time limited.
Please go to the try-it/trial section in https://www.openinventor.com for
getting a trial license.

After the trial period expires, you will need to get a new license in
order to continue running Open Inventor programs. You will either need to
purchase a license, or if you have current maintenance, you can
request a license from your sales manager.

Please go to the support/contacts section in https://www.openinventor.com
to request a license.


Contacts
--------------------------------------------------

If you need to contact us regarding Open Inventor, please go to the 
support/contacts section in https://www.openinventor.com

