#include <BasicJQueryGUIRenderAreaListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Connection.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>


void BasicJQueryGUIRenderAreaListener::onReceivedMessage(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> /*sender*/, const std::string& message)
{
  SoSeparator* root = (SoSeparator*) renderArea->getSceneManager()->getSceneGraph();

  SoSwitch *colorSwitch = (SoSwitch*)root->getChild(3);

  // parse the received message
  if (message == "color on")
  {
    colorSwitch->whichChild = 0;
  }
  else if (message == "color off")
  {
    colorSwitch->whichChild = -1;
  }
}
