/*
 * Open Inventor v10.18.1
 * https://developer.openinventor.com/
 */
/**
 * Open Inventor RemoteViz Client HTML5
 * @version v8.8.2
 */
/*~ This file is the TypeScript declaration file of the RemoteViz Client Javascript API.
 *~ Open Inventor from Thermo Fisher Scientific (www.openinventor.com).
 */

/*~ Note that ES6 modules cannot directly export class objects.
 *~ This file should be imported using the CommonJS-style:
 *~   /// <reference path="RemoteVizClient.d.ts" />
 *~   import RemoteVizRenderArea = require('./RemoteVizClient');
*/

declare class RemoteVizRenderArea {
  
  constructor(container:HTMLElement|string, renderElementWidth:number, renderElementHeight:number, displayMode?:'FIT'|'CROP'|'STRETCH')
  
  connectTo(serviceUrl:string) : void
  
  disconnect() : void
  
  isConnected() : boolean
  
  sendMessage(message:string|Uint8Array) : void
  
  requestRenderAreaSize(width:number, height:number) : void
  
  resizeRenderAreaContainer(width:number, height:number) : void
  
  getRenderAreaWidth() : number
  
  getRenderAreaHeight() : number
  
  getContainerWidth() : number
  
  getContainerHeight() : number
  
  isImageStreamingSupported() : boolean
  
  isVideoStreamingSupported() : boolean
  
  getStreamingMode() : 'unknown' | 'image' | 'video'
  
  addServiceListener( callback: ( args: any[] ) => void ) : void
  
  removeServiceListener( callback: ( args: any[] ) => void) : void
  
  addResizeListener( callback: ( size: [number, number] ) => void ) : void
  
  removeResizeListener( callback: ( size: [number, number] ) => void ) : void
  
  addReceivedFrameListener( callback: ( args: [number, number, string] ) => void ) : void
  
  removeReceivedFrameListener( callback: ( args: [number, number, string] ) => void ) : void
  
  addDecodedFrameListener( callback: ( args: [number, boolean, string] ) => void ) : void
  
  removeDecodedFrameListener( callback: ( args: [number, boolean, string] ) => void ) : void
  
  addMessageListener( callback: ( message:string|Uint8Array ) => void ) : void
  
  removeMessageListener( callback: ( message:string ) => void ) : void
  
  addMouseUpListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseUpListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseDownListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseDownListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseDoubleClickListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseDoubleClickListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseMoveListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseMoveListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseOverListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseOverListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseOutListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  removeMouseOutListener( callback: ( event:MouseEvent ) => boolean ) : void
  
  addMouseWheelListener( callback: ( event:WheelEvent ) => boolean ) : void
  
  removeMouseWheelListener( callback: ( event:WheelEvent ) => boolean ) : void
  
  addTouchStartListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  removeTouchStartListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  addTouchEndListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  removeTouchEndListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  addTouchCancelListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  removeTouchCancelListener( callback: ( event:TouchEvent ) => boolean ) : void

  addTouchMoveListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  removeTouchMoveListener( callback: ( event:TouchEvent ) => boolean ) : void
  
  addKeyUpListener( callback: ( event:KeyboardEvent ) => boolean ) : void
  
  removeKeyUpListener( callback: ( event:KeyboardEvent ) => boolean ) : void
  
  addKeyDownListener( callback: ( event:KeyboardEvent ) => boolean ) : void
  
  removeKeyDownListener( callback: ( event:KeyboardEvent ) => boolean ) : void

}

export = RemoteVizRenderArea;
