#include <ConnectionManagementServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Service.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoGradientBackground.h>

#define MAXCONNECTION 3

//--------------------------------------------------------------------------------
bool ConnectionManagementServiceListener::signin(std::string &login, std::string& password)
{
  /* Check if the login and the password are correct */

  if (login == "user" && password == "password")
  {
    return true;
  }
  else
  {
    return false;
  }
}

//--------------------------------------------------------------------------------
bool ConnectionManagementServiceListener::accept(std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters)
{
  /* These parameters refer to the GET parameters in the service URI. (see index.html) */
  std::string login = parameters->getValue("login");
  std::string password = parameters->getValue("password");

  if ( (RemoteViz::Rendering::Service::instance()->getRenderArea(0) == NULL || RemoteViz::Rendering::Service::instance()->getRenderArea(0)->getNumConnections() < MAXCONNECTION) 
    && signin(login, password) )
  {
    return true;
  }
  else
  {
    return false;
  }
}

//--------------------------------------------------------------------------------
bool ConnectionManagementServiceListener::onPendingCreateRenderArea(const std::string& /*renderAreaId*/, unsigned int& /*width*/, unsigned int& /*height*/, std::shared_ptr<RemoteViz::Rendering::RenderAreaHardware> /*renderAreaHardware*/, std::shared_ptr<RemoteViz::Rendering::Client> /*client*/, std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters)
{
  /* Triggered when a connection is pending and the requested renderArea doesn't exist. */

  return accept(parameters); // Check if the user is accepted
}

//--------------------------------------------------------------------------------
bool ConnectionManagementServiceListener::onPendingShareRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> /*renderArea*/, std::shared_ptr<RemoteViz::Rendering::Client> /*client*/, std::shared_ptr<const RemoteViz::Rendering::ConnectionParameters> parameters)
{
  /* Triggered when a connection is pending and the requested renderArea exists. */

  return accept(parameters); // Check if the user is accepted
}

//--------------------------------------------------------------------------------
void ConnectionManagementServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  auto renderAreaListener = std::make_shared<RemoteViz::Rendering::RenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer* examiner = new SceneExaminer();

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  // Scene graph
  examiner->addChild(new SoGradientBackground());
  examiner->addChild(new SoCone());

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());
}
