#pragma once
#include <RemoteViz/Rendering/RenderAreaListener.h>
#include <map>
#include <deque>
#include <mutex>

class FrontBackSyncRenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:
  /*
  *
  *  Triggered before a rendering is done.
  *  Default behavior : Do the rendering by returning true.
  *
  *  In the ServiceSettings#INDEPENDENT_SERVICE mode, this callback is never triggered.
  *
  *  \param renderArea : the RenderArea that will perform the rendering.
  *
  *  \param clearWindow : if true, this clears the graphics window before rendering
  *
  *  \param clearZbuffer : if true, the z buffer will be cleared before rendering
  *
  *  \return false to abort the rendering. \n If there are many listeners, the logical operator OR will
  *  be applied on all the returned value of listeners. \n If there are no listeners to call, the rendering
  *  will be not aborted.
  *
  */
  virtual bool onPreRender( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, bool& clearWindow, bool& clearZbuffer ) override;

  /*
  *  Triggered before sending a frame to the client.
  *  The sending frame can be retrieved using Connection#getLastEncodedFrame.
  *  IMPORTANT: This callback is executed in a separate thread for each connection sending a frame.
  *
  *  \param renderArea : the RenderArea of the Connection
  *
  *  \param sender : the connection that will send the frame to the client
  *
  *  \param message : This value can be modified to attach a text message to the frame. Default value is an empty string.
  *                   This message can be retrieved from the client listeners: onReceivedFrame and onDecodedFrame.\n
  *
  */
  virtual void onSendingFrame( std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea,
                               std::shared_ptr<RemoteViz::Rendering::Connection> sender,
                               std::string& message ) override;

  void setMatrix( SbMatrix m );

private:
  std::mutex m_mutex;
  std::map<size_t, std::string> m_frameIdMatrix;
  std::deque<size_t> m_frameIds;
  SbMatrix m_mvp;
};
