#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include "FrontBackSyncRenderAreaListener.h"
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>
#include <Inventor/SbMatrix.h>

class FrontBackSyncServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /*!
  *
  *  Triggered when a renderArea has been instanciated.
  *
  *  \param renderArea : pointer to the instanciated renderArea
  */
  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea) override;

private:
  static void callback(void* data, SoAction* action);
};
