#pragma once
#include <RemoteViz/Rendering/RenderAreaListener.h>

class HelloConeH264RenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:
  /*!
  *
  *  Triggered when a client connects.\n
  *  If the frame encoder can not be initialized, RenderAreaListener#onRefusedEncoder will be triggered.
  *  Otherwise, RenderAreaListener#onAcceptedEncoder will be triggered.\n
  *  Default behavior : JPEG encoder.
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param connection : pointer to the Connection
  *
  *  \param frameEncoders : encoders used by the Connection to encode interactive and still frames
  */
  virtual void onOpenedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> connection, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders) override;

  /*!
  *
  *  Triggered when the connection and the frame encoder are initialized successfully.\n
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param sender : pointer to the connection
  *
  *  \param frameEncoders : frame encoders that have been initialized by the connection
  */
  virtual void onInitializedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> frameEncoders) override;

  /*!
  *
  *  Triggered when a frame encoder can not be initialized.\n
  *  If this case occurs, set another frame encoder.
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param sender : pointer to the connection that requests a frame encoder
  *
  *  \param frameEncoders : frame encoders refused by the service
  */
  virtual void onRefusedEncoder(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders) override;
};

