#include <HelloConeVP9ServiceListener.h>
#include <HelloConeVP9RenderAreaListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>
#include <Inventor/nodes/SoCone.h>
#include <Inventor/nodes/SoGradientBackground.h>
#include <Inventor/actions/SoGLRenderAction.h>

#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

void HelloConeVP9ServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate a renderAreaListener class to manage the renderArea events (default behaviors).
  auto renderAreaListener = std::make_shared<HelloConeVP9RenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Instantiate a sceneExaminer to interact with the camera
  SceneExaminer *examiner = new SceneExaminer();

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  // Scene graph
  examiner->addChild(new SoCone());
  examiner->addChild(new SoGradientBackground());

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(examiner);

  // Enable Antialiasing (if required)
  // renderArea->getSceneManager()->setAntialiasing(1.f);

  // Enable Transparency (if required)
  // renderArea->getSceneManager()->getGLRenderAction()->setTransparencyType(SoGLRenderAction::SORTED_PIXEL);

  // viewall
  examiner->viewAll(renderArea->getSceneManager()->getViewportRegion());
}


