#pragma once

#include <RemoteViz/Rendering/RenderAreaListener.h>

#include <list>
#include <mutex>

class SbRasterImage;

class Engine;

class IndependentRenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:

  /**
  *  Constructor
  */
  IndependentRenderAreaListener(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea);

  /**
  *  Destructor
  */
  ~IndependentRenderAreaListener();

  /**
  *  Triggered when a client disconnects.\n
  */
  virtual void onClosedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, const std::string& connectionId, bool aborted) override;

  /**
  *  Triggered when the renderArea is resized.\n
  */
  virtual void onResize(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, unsigned int width, unsigned int height) override;

  /**
  *  Triggered when a MouseUp event is received from the client.
  */
  virtual bool onMouseUp(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, int x, int y, SoMouseButtonEvent::Button button) override;

  /**
  *  Triggered when a MouseDown event is received from the client.\n
  */
  virtual bool onMouseDown(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, int x, int y, SoMouseButtonEvent::Button button) override;

  /**
  *  Triggered when a MouseMove event is received from the client.\n
  */
  virtual bool onMouseMove(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, int x, int y) override;

  /**
  *  Triggered when a new frame is requested by a connection.
  */
  virtual void onRequestedFrame(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, SbRasterImage* rasterImage, bool& isInteractive) override;

private:
  /**
  *  Copy pixels array to SbRasterImage
  */
  void copyImageBufferToRasterImage(SbRasterImage* rasterImage, unsigned char* data);

  Engine* m_engine;

  std::shared_ptr<RemoteViz::Rendering::RenderArea> m_renderArea;

  std::map<std::string, size_t> m_lastConnectionFrame;

  std::mutex m_listMutex;
};
