#include <IndependentServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>

#include <IndependentRenderAreaListener.h>

void IndependentServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate the class overriding the renderAreaListener class to manage the renderArea events.
  auto renderAreaListener = std::make_shared<IndependentRenderAreaListener>(renderArea);

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);
}
