#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include <RemoteViz/Rendering/RenderAreaListener.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

class InventorApplicationServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /*!
  *
  *  Scene Graph
  */
  static SceneExaminer *root;

  /*!
  *
  *  Triggered when a renderArea has been instanciated.
  *
  *  \param renderArea : pointer to the instanciated renderArea
  */
  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea);
};

