#include <InventorApplicationServiceListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <Inventor/SoSceneManager.h>
#include <Inventor/touch/SoTouchManager.h>

SceneExaminer* InventorApplicationServiceListener::root = NULL;

void InventorApplicationServiceListener::onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea)
{
  // Instantiate a renderAreaListener class to manage the renderArea events (default behaviors).
  auto renderAreaListener = std::make_shared<RemoteViz::Rendering::RenderAreaListener>();

  // Add the renderAreaListener instance as renderArea listener
  renderArea->addListener(renderAreaListener);

  // Add recognizers for gesture events
  renderArea->getTouchManager()->addDefaultRecognizers();

  // Apply the sceneExaminer node as renderArea scene graph
  renderArea->getSceneManager()->setSceneGraph(root);
  // Let SceneExaminer node manage the interactive mode
  renderArea->getSceneManager()->setAutoInteractiveMode( false );

  // Viewall
  root->viewAll(renderArea->getSceneManager()->getViewportRegion());

  // To be sure to have a render when the renderarea is initialised
  renderArea->getSceneManager()->scheduleRedraw();
}
