#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include <RemoteViz/Rendering/RenderAreaListener.h>
#include <RemoteViz/Rendering/ServiceSettings.h>
#include <Inventor/SbColor.h>

class LoadBalancedServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /**
   *
   *  Constructor.
   */
  LoadBalancedServiceListener(std::shared_ptr<const RemoteViz::Rendering::ServiceSettings> settings);

  /**
   *
   *  Triggered when a renderArea has been instanciated.
   *
   *  \param renderArea : pointer to the instanciated renderArea
   */
  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea) override;
  
  /**
   *
   *  Triggered when a renderArea has been disposed. See RenderArea#closeConnectionsAndDispose.\n\n
   *  Default behavior : do nothing
   *
   *  \param renderAreaId : ID identifying the disposed renderArea
   */
  virtual void onDisposedRenderArea(const std::string &renderAreaId) override;

private:
  SbColor m_color;
};
