#include <LoadBalancedRenderAreaListener.h>
#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Service.h>
#include <RemoteViz/Rendering/ServiceSettings.h>
#include <string>

//--------------------------------------------------------------------------------
void LoadBalancedRenderAreaListener::onInitializedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection>, std::shared_ptr<const RemoteViz::Rendering::FrameEncoders> )
{
  const std::string ip = RemoteViz::Rendering::Service::instance()->getSettings()->getIP();
  const std::string port = std::to_string(RemoteViz::Rendering::Service::instance()->getSettings()->getPort());
  renderArea->sendMessage( ip + ":" + port );
}
