#pragma once
#include <string>
#include <vector>
#include <thread>
#include <queue>
#include <mutex>
#include <condition_variable>
#include <functional>

class InfluxdbMetricsDispatcher {
  typedef std::function<void()> fp_t;

public:
  InfluxdbMetricsDispatcher();
  ~InfluxdbMetricsDispatcher();

  // dispatch and copy
  void dispatch( const fp_t& op );

  // Deleted operations
  InfluxdbMetricsDispatcher( const InfluxdbMetricsDispatcher& rhs ) = delete;
  InfluxdbMetricsDispatcher& operator=( const InfluxdbMetricsDispatcher& rhs ) = delete;
  InfluxdbMetricsDispatcher( InfluxdbMetricsDispatcher&& rhs ) = delete;
  InfluxdbMetricsDispatcher& operator=( InfluxdbMetricsDispatcher&& rhs ) = delete;

private:
  std::mutex lock_;
  std::thread thread_;
  std::queue<fp_t> q_;
  std::condition_variable cv_;
  bool quit_ = false;

  void dispatchThreadHandler( void );
};
