#include <InfluxdbMetricsDispatcher.h>
#include <iostream>

InfluxdbMetricsDispatcher::InfluxdbMetricsDispatcher()
{
  thread_ = std::thread( &InfluxdbMetricsDispatcher::dispatchThreadHandler, this );
}

InfluxdbMetricsDispatcher::~InfluxdbMetricsDispatcher()
{
  // Send a quit signal to the dispatching thread
  std::unique_lock<std::mutex> lock( lock_ );
  quit_ = true;
  lock.unlock();
  cv_.notify_all();

  // Wait for the thread to finish before we exit
  if (thread_.joinable())
      thread_.join();
}

//--------------------------------------------------------------------------------
/*
 * Add a function to the thread execution queue
 */
void InfluxdbMetricsDispatcher::dispatch( const fp_t& op )
{
  std::unique_lock<std::mutex> lock( lock_ );
  q_.push( op );
  lock.unlock();
  cv_.notify_all();
}

//--------------------------------------------------------------------------------
/*
 * Wait for a function to be inserted in the queue and executes it
 * Also, closes the thread when asked
 */
void InfluxdbMetricsDispatcher::dispatchThreadHandler( void )
{
  std::unique_lock<std::mutex> lock( lock_ );

  do {
    // Wait until we have data or a quit signal
    cv_.wait( lock, [this] {
      return (q_.size() || quit_);
    } );

    if (!quit_ && q_.size())
    {
      auto op = std::move( q_.front() );
      q_.pop();
      lock.unlock();

      // Execute the function
      op();

      lock.lock();
    }
  } while (!quit_);
}
