RemoteViz Monitoring with Grafana/InfluxDB {#RemoteVizMonitoringWithGrafanaInfluxDB}
==========================

In this demo, the *MonitoringMetricsListener* is sending metrics directly to
InfluxDB using the UDP protocol. All metrics are then accessible on a dashboard
displayed by **Grafana**. We are using **Docker Compose** to create and manage the
Grafana / InfluxDB part of the demo.

* The *GrafanaMonitoredRenderingService* folder contains the RemoteViz service
  demo.
* The *DockerCompose* folder contains all necessary files to start monitoring the
  demo.

## Using Docker Compose
Install **Docker**:
* Linux, macOS (> 2010) and Windows 10: https://docs.docker.com/install/#supported-platforms
* macOS (< 2010) and Windows 7: https://docs.docker.com/toolbox/overview/

Install **Docker Compose**: https://docs.docker.com/compose/install/

Start and stop the services:

```sh
# On Windows 7, the demo folder MUST be located on the C: drive
# (or you need to edit the Docker Toolbox configuration)
cd /c/path/to/the/demo/folder/DockerCompose

# If not on Windows 7 go into the demo folder
cd $OIVHOME/examples/source/RemoteViz/Monitoring/MonitoringGrafana/DockerCompose

# To start the services
docker-compose up -d

# At the end, to stop the services
docker-compose stop

# Or to remove the containers and clean the volumes (clean all metrics from DB)
docker-compose down --volumes
```

### Access the Grafana dashboard

#### On Linux, Docker for Mac or Docker for Windows

Grafana should now be listening on port 3000 on your Docker daemon host.
Enter http://0.0.0.0:3000/ in a browser to see the application running.

#### With Docker Toolbox

Get the IP address of your Docker host:

```sh
# If you did not change the machine name
docker-machine ip default
```
Open `http://MACHINE_VM_IP:3000` in a browser.
In that case, you also need to ***either*** :
  * Edit the **influxdb_ip** variable in the *MonitoringMetricsListener.cxx* file
  * Setup some port forwarding rules for the Docker machine in **VirtualBox**:
```sh
# If the VirtualBox install directory is in your PATH, run:
VBoxManage controlvm "default" natpf1 "influxdb_udp,udp,127.0.0.1,4444,,4444"
VBoxManage controlvm "default" natpf1 "influxdb_http,tcp,127.0.0.1,8086,,8086"
```

## Monitoring process

1. Start the Docker Compose services
2. Start the RemoteViz Advanced Monitoring demo
3. Open the `index.html` page inside the Monitoring/Client folder
4. Open Grafana (**Username**: admin | **Password**: remoteviz)
5. Go to the *RemoteViz Monitoring Dashboard* (Dashboard->Manage->RemoteViz Monitoring Dashboard)
