#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include <RemoteViz/Rendering/RenderAreaListener.h>

class SecureConnectionServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /*!
   *
   *  Triggered when a renderArea has been instanciated.
   *
   *  \param renderArea : pointer to the instanciated renderArea
   */
  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea) override;
  /**
   * Triggered when the secure connection is enabled. 
   * This callback has to return the private key passphrase.
   *
   * If the private key does not contain a passphrase, do not implement this callback. The default implementation will return an empty string.
   *
   * Security warning !! DO NOT hard-code the passphrase into this callback !!\n
   * Read it from a SECURE location on your system.\n\n
   *
   * @see ServiceSettings#enableSecureConnection
   *
   * Default behavior : returns an empty string.
   */
   virtual std::string onRequestedPrivateKeyPassphrase() override;
};

