<?php

include_once("model/Market.php");
include_once("model/Data.php");

class Model {
	private $_dataFolderPath;
	private $_rootDataFolder;
	
	public function __construct()
	{
		$this->_dataFolderPath = getenv("OIVHOME") . "/examples/source/RemoteViz/";
		$this->_rootDataFolder = "data";
	}

	private function getMarketList()
	{
		$marketList = array();
		$directories = array_map('basename', glob($this->_dataFolderPath . $this->_rootDataFolder . '/*' , GLOB_ONLYDIR));
		foreach ($directories as $filename)
		{
			array_push($marketList, new Market($this->_rootDataFolder . '/' . $filename, $filename));
		}

		return $marketList;
	}

	public function getDataList()
	{
		$dataList = array();
		$marketList = $this->getMarketList();
		foreach ($marketList as $market)
		{
			$directories = array_map('basename', glob($this->_dataFolderPath . $market->getPath() . '/*.iv'));

			foreach ($directories as $data)
			{
				array_push($dataList, new Data($market, $data));
			}
		}

		return $dataList;
	}

}

?>
