<!DOCTYPE html>
<html>
<head>
    <title>Shared Viewer - RemoteViz</title>
    <meta name="viewport" content="user-scalable=no,width=device-width, initial-scale=1, minimum-scale=1.0, maximum-scale=1" /> <!-- The meta viewport tag contains instructions to the browser in the matter of viewports and zooming. -->
    <meta name="apple-mobile-web-app-capable" content="yes" /><meta name="apple-mobile-web-app-status-bar-style" content="black" />  <!-- Sets the style of the status bar for a web application. -->
    <meta http-equiv="CACHE-CONTROL" content="NO-CACHE" /><meta http-equiv="X-UA-Compatible" content="IE=edge" /> <!--  The X-UA-Compatible meta tag allows you to choose what version of Internet Explorer the page should be rendered as -->

    <!-- Jquery mobile -->
    <link rel="stylesheet" type="text/css" href="resources/css/loader.css"> <!-- include the loader css -->
    <link rel="stylesheet" href="resources/jquery/jquery.mobile-1.3.2.min.css" />
    <script type="text/javascript" src="resources/jquery/jquery-1.9.1.min.js"></script>
    <script type="text/javascript" src="resources/jquery/jquery.mobile-1.3.2.min.js"></script>

    <!-- demo stylesheet -->
    <link rel="stylesheet" type="text/css" href="resources/css/StyleSheet.css" />

    <!-- RemoteVizHTML5 library -->
    <script type="text/javascript" src="RemoteVizClient.js"></script>

    <script type="text/javascript">
        // create a array to load the data structure
        <?php
            $models = array();
            foreach ($dataList as $data)
            {
                array_push($models, '["' . $data->getPath() . '","' . $data->getName() . '"]');
            }
            echo 'var items = [' . implode(",", $models) . '];';
        ?>
    </script>

    <!-- demo javascript -->
    <script type="text/javascript" src="resources/js/SharedViewer.js"></script>
</head>

<body>
    <!-- loader notifying the network bandwidth calibration -->
    <div id="loaderGroup" style="display:none;">
        <div id="loader"></div>
        <div id="loaderText">Network calibration</div>
    </div>
    <div data-role="page" class="type-interior">
        <div id="container">
            <!-- element displaying the renderArea -->
            <div id="TheDiv" class="full">
            </div>
            <div class="panel">
                <h3>RemoteViz</h3>
                <div class="menu-left">
                    <!-- add list to select 3 sessions -->
                    <select name="select-session" id="select-session">
                        <option value="session1">Session 1</option>
                        <option value="session2">Session 2</option>
                        <option value="session3">Session 3</option>
                    </select>
                    <p id="clients"></p>
                </div>
                <div style="clear:both;"></div>
                <div class="menu-left">
                    <fieldset data-role="controlgroup" data-type="horizontal">
                        <input type="checkbox" name="checkbox-picking" id="checkbox-picking" title="Picking mode"/>
                        <label for="checkbox-picking"><img src="resources/Images/pointer.png" id="picking-img" /></label>

                        <!-- add list to select the market -->
                        <select data-native-menu="false" name="select-market" id="select-market">
                            <option value="" data-placeholder='true'>Choose one...</option>
                            <!-- Display the market folders -->
                            <?php
                                foreach ($dataList as $data)
                                {
                                   $market = $data->getMarket();
                                   echo '<option value="' . $market->getPath() . '" data-icon="false" class="radio-choice">' . $market->getName() . '</option>';
                                }
                            ?>
                        </select>

                        <!-- add list to select the model -->
                        <select name="select-model" id="select-model">
                        </select>
                    </fieldset>
                </div>
                <div style="clear:both;"></div>
                <a class="trigger-r" href="#"></a>
            </div>
        </div>
    <a class="trigger" href="#"></a>
    </div>
</body>
</html>
