#pragma once
#include <RemoteViz/Rendering/RenderAreaListener.h>

class SharedViewerRenderAreaListener : public RemoteViz::Rendering::RenderAreaListener
{
public:
  /*!
  *
  *  Constructor
  */
  SharedViewerRenderAreaListener();
  /*!
  *
  *  Triggered when a client connects.\n\n
  *  Default behavior : do nothing
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param connection : pointer to the Connection
  *
  *  \param frameEncoders : encoders used by the Connection to encode interactive and still frames
  */
  virtual void onOpenedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> connection, std::shared_ptr<RemoteViz::Rendering::FrameEncoders> frameEncoders) override;
  /*!
  *
  *  Triggered when a client disconnects.\n\n
  *  Default behavior : dispose the renderArea if all the connections are close.
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param connectionId : ID identifying the connection
  *
  *  \param aborted : true if the network connection was closed unexpectedly by the client or has been lost.
  */
  virtual void onClosedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, const std::string& connectionId, bool aborted) override;
  /*!
  *
  *  Triggered when a message is received from a client.
  *
  *  \param renderArea : pointer to the RenderArea
  *
  *  \param message : the message sent by the client
  *
  *  \param sender : pointer to the Connection
  */
  virtual void onReceivedMessage(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, const std::string& message) override;

private:

  bool m_picking;
  std::string m_model;

};
