#pragma once
#include <RemoteViz/Rendering/ServiceListener.h>
#include "SharedViewerRenderAreaListener.h"
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>
#include <memory>

class SharedViewerServiceListener : public RemoteViz::Rendering::ServiceListener
{
public:
  /*!
  *
  *  Constructor
  */
  SharedViewerServiceListener();

  /*!
  *
  *  Triggered when a renderArea has been instanciated.
  *
  *  \param renderArea : pointer to the instanciated renderArea
  */
  virtual void onInstantiatedRenderArea(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea) override;

private:
  std::shared_ptr<SharedViewerRenderAreaListener> m_renderAreaListener_session1;
  std::shared_ptr<SharedViewerRenderAreaListener> m_renderAreaListener_session2;
  std::shared_ptr<SharedViewerRenderAreaListener> m_renderAreaListener_session3;
};

