#include <SharedViewerRenderAreaListener.h>

#include <RemoteViz/Rendering/RenderArea.h>
#include <RemoteViz/Rendering/Connection.h>

#include <Inventor/SoSceneManager.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoSwitch.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSelection.h>

#include <string>
#include <list>
#include <sstream>

#include <Inventor/ViewerComponents/nodes/SceneExaminer.h>

//--------------------------------------------------------------------------------
SharedViewerRenderAreaListener::SharedViewerRenderAreaListener()
{
  m_picking = false;
}

//--------------------------------------------------------------------------------
std::string to_string (unsigned int a)
{
  std::ostringstream ssa;
  ssa << a;
  return ssa.str();
}

//--------------------------------------------------------------------------------
std::list<std::string> &split(const std::string &s, char delim, std::list<std::string> &elems) 
{
  std::stringstream ss(s);
  std::string item;
  while (std::getline(ss, item, delim)) 
  {
    elems.push_back(item);
  }
  return elems;
}

//--------------------------------------------------------------------------------
void SharedViewerRenderAreaListener::onOpenedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> connection, std::shared_ptr<RemoteViz::Rendering::FrameEncoders>)
{
  /* Send a message to all the clients of the same renderArea to synchonize the UI */

  if (m_picking)
  {
    connection->sendMessage("pick on");
  }
  else
  {
    connection->sendMessage("pick off");
  }

  connection->sendMessage(m_model);

  // Notify the number of connected clients
  renderArea->sendMessage("clients " + ::to_string(renderArea->getNumConnections()));
}

//--------------------------------------------------------------------------------
void SharedViewerRenderAreaListener::onClosedConnection(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, const std::string& /*connectionId*/, bool /*aborted*/ )
{
  // Notify the number of connected clients
  renderArea->sendMessage("clients " + ::to_string(renderArea->getNumConnections()));
}

//--------------------------------------------------------------------------------
void SharedViewerRenderAreaListener::onReceivedMessage(std::shared_ptr<RemoteViz::Rendering::RenderArea> renderArea, std::shared_ptr<RemoteViz::Rendering::Connection> sender, const std::string& message)
{

  SoSelection* sel = (SoSelection*) renderArea->getSceneManager()->getSceneGraph();
  SceneExaminer* sceneExaminer = (SceneExaminer*) sel->getChild(0);

  std::list<std::string> elems;
  split(message, ' ', elems); // split the received message, pattern : "COMMAND ARGUMENT"

  std::string command = elems.front();
  elems.pop_front();
  std::string argument = elems.front();

  // parse the commands
  if (command == "open")
  {
    // Load the new iv file
    SoInput i;
    i.openFile( "$OIVHOME/examples/source/RemoteViz/" + argument );
    sceneExaminer->removeChild(sceneExaminer->getNumChildren() - 1);
    sceneExaminer->addChild(SoDB::readAll(&i));
    sceneExaminer->viewAll(renderArea->getSceneManager()->getViewportRegion());
    m_model = message;
  }
  else if (command == "pick")
  {
    // picking mode switch
    if (argument == "on")
    {
      sceneExaminer->setInteractionMode(SceneExaminer::SELECTION);
      m_picking = true;
    }
    else
    {
      sceneExaminer->setInteractionMode(SceneExaminer::NAVIGATION);
      m_picking = false;
    }
  }

  /* Send a message to all the clients of the same renderArea to synchonize the UI */
  std::vector<std::shared_ptr<RemoteViz::Rendering::Connection>> excludedConnections;
  excludedConnections.push_back(sender);
  renderArea->sendMessage(message, excludedConnections);
}
