/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Jan 2008)
**=======================================================================*/
#ifndef SO_GUI_H
#define SO_GUI_H

#include <Inventor/sys/port.h>
#include <Inventor/SbBasic.h>

#include <SoVersion.h>
#ifndef HIDDEN_FROM_DOC

#include <Inventor/Gui/SoInventorGuiLibName.h>

#if defined(_WIN32)
#  ifndef InventorGui_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__INVENTORGUILIB)
#    endif
#  endif
#endif

#endif // HIDDEN_FROM_DOC

#include <Inventor/SoModule.h>
#ifndef HIDDEN_FROM_DOC
SO_MODULE_HEADER(SoInventorGui, __INVENTORGUIDLL)
#endif

/** [OIV-WRAPPER-NO-WRAP] */
class INVENTORGUI_API SoGui
{
SoINTERNAL public:
  /**
   * Init SoGui module.
   */
  static void init();

#if SoDEPRECATED_BEGIN(10000)
  SoDEPRECATED_METHOD(10000, "Use SoGui::init() instead.")
  static void threadInit();
#endif /** @DEPRECATED_END */

  /**
   * Finish SoGui module.
   */
  static void finish();

  /**
   * Returns TRUE if module is currently initialized.
   */
  static bool isInitialized();

private:
  static int s_initRefCount;
};

#endif // SO_GUI_H

