/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _PO_SCENE_VIEW_
#define  _PO_SCENE_VIEW_

#include <Inventor/fields/SoSFBool.h>
#include <Inventor/Gui/view/PoBaseView.h>

class SoFieldSensor ;

/**
 * @VSGEXT  Class to define a view which contains a scene.
 * 
 * @ingroup GuiView
 * 
 * @DESCRIPTION
 *   This class allows the user to define a view which contains a scene.
 *
 *   Views allow the application to specify multiple cameras, each with its
 *   own separate viewport (region of the 3D window). This is more powerful
 *   than just using multiple SoCamera nodes, because camera nodes do not
 *   allow specifying a viewport (the viewport is always the full window).
 *   See PoBaseView for more explanation.
 *
 *   A scene is a set of any nodes (except SoCamera nodes) placed under an SoGroup node 
 *    which must be seen in a viewport according to a camera configuration. To 
 *    define a view, set the fields #viewportOrigin and #viewportSize according to 
 *    the viewport position and size you want to have (relative to the display 
 *    window sizes), configure the camera (set the part cameraKit), build the scene 
 *    under an SoGroup node, and set this scene to the view (set the part scene). All 
 *    shape nodes contained in the scene will be drawn in the viewport previously 
 *    defined and according to the camera definition. You can define as many views 
 *    as you want.
 *
 *    @B NOTES: @b
 *    - If you use a viewer, you should call the method 
 *      SoBaseKit::setSearchingChildren(TRUE) to allow the viewer to search
 *      for cameras inside nodekits (like this one).
 *    - Do not place a camera node before this nodekit.
 *    - Create a camera for each view and set it using the setPart method. 
 *      See example.
 *    - When you use HardCopy, the graphics window is the paper sheet.
 *    - \if_cpp SoGui::init() needs to be called in order to initialize this class
 *      (this is done automatically if you use SoXt, SoWin or SoQt).\endif
 *
 *    @B LIMITATIONS: @b
 *    - The field SoCamera::viewportMapping must be equal to 
 *      ADJUST_CAMERA in order to have a correct vectorisation when you use  
 *      HardCopy,
 *    - Do not use the SoBoxHighlightRenderAction class on a scene graph which contains 
 *      a view,
 *    - Do not push view, 
 *    - Be careful when you use the method viewAll() of the class SoXtViewer, because 
 *      this method works on the entire scene graph and not on a portion of a scene 
 *      graph. Overload this method according to your requirements,
 *    - Some of the viewer functions/buttons do not work correctly with views. @BR
 *      For example, saveHomePosition() and resetToHomePosition() do not work correctly
 *      because the viewer only stores one copy of the camera.
 *    - The viewer rendering options, e.g. wireframe, apply to ALL views inside the
 *      viewer.  You can implement these effects per-view using an SoDrawStyle node
 *      and setOverride() if necessary.
 *    - In case of tile rendering with SoOffscreenRenderArea : SoGradientBackground in a
 *      PoSceneView will not be rendered with the correct size (i.e. the SoGradientBackground
 *      size will not match the target size). Call SoOffscreenRenderArea.setTileSize()
 *      with the offscreen rendering total size to avoid this size problem.
 *
 * @EXAMPLE
 * \if_cpp 
 *   \code
 *   // Must enable this option or viewer will not be able to find the camera in the PoSceneView nodeKit.
 *   SoBaseKit::setSearchingChildren( TRUE );
 *
 *   // First scene graph
 *   SoSeparator* scene1 = new SoSeparator();
 *   scene1->addChild( new SoCone() );
 *
 *   // First view (lower left corner of window)
 *   PoSceneView* view1 = new PoSceneView();
 *   view1->sensitiveOnEvents( TRUE );
 *   view1->isBorderVisible.setValue( TRUE );
 *   view1->viewportOrigin.setValue( 0, 0 );
 *   view1->viewportSize.setValue( 0.5f, 0.5f );
 *   SoPerspectiveCamera* cam1 = new SoPerspectiveCamera();
 *   view1->setPart( "cameraKit.camera", cam1 );
 *   view1->setPart( "scene", scene1 );
 *   cam1->viewAll( scene1, SbViewportRegion(100, 100) );
 *   root->addChild( view1 );
 *
 *   // Second scene graph
 *   SoSeparator* scene2 = new SoSeparator();
 *   scene2->addChild( new SoCube() );
 *
 *   // Second view (upper right quadrant of window)
 *   PoSceneView* view2 = new PoSceneView();
 *   view2->sensitiveOnEvents( TRUE );
 *   view2->isBorderVisible.setValue( TRUE );
 *   view2->set( "borderApp.drawStyle", "lineWidth 1.5" ); // Work-around for border
 *   view2->viewportOrigin.setValue( 0.5f, 0.5f );
 *   view2->viewportSize.setValue( 0.5f, 0.5f );
 *   SoPerspectiveCamera* cam2 = new SoPerspectiveCamera();
 *   view2->setPart( "cameraKit.camera", cam2 );
 *   view2->setPart( "scene", scene2 );
 *   cam2->viewAll( scene2, SbViewportRegion(100, 100) );
 *   root->addChild( view2 );
 *
 *   viewer->setSceneGraph( root );
 *   \endcode
 * \endif
 * \if_dotnet
 *   \code
 *   // Must enable this option or viewer will not be able to find the camera in the PoSceneView nodeKit.
 *   SoBaseKit.SetSearchingChildren(true);
 *
 *   // First scene graph
 *   SoSeparator scene1 = new SoSeparator();
 *   scene1.AddChild( new SoCone() );
 *
 *   // First view (lower left quadrant of window)
 *   PoSceneView view1 = new PoSceneView();
 *   view1.SensitiveOnEvents(true);
 *   view1.isBorderVisible.Value = true;
 *   view1.viewportOrigin.SetValue(0, 0);
 *   view1.viewportSize.SetValue(0.5f, 0.5f);
 *   SoPerspectiveCamera cam1 = new SoPerspectiveCamera();
 *   view1.SetPart("cameraKit.camera", cam1);
 *   view1.SetPart("scene", scene1);
 *   cam1.ViewAll(scene1, new SbViewportRegion(100, 100));
 *   root.AddChild(view1);
 *
 *   // Second scene graph
 *   SoSeparator scene2 = new SoSeparator();
 *   scene2.AddChild( new SoCube() );
 *
 *   // Second view (upper right quadrant of window)
 *   PoSceneView view2 = new PoSceneView();
 *   view2.SensitiveOnEvents(true);
 *   view2.isBorderVisible.Value = true;
 *   view2.Set("borderApp.drawStyle", "lineWidth 1.5"); // Work-around for border
 *   view2.viewportOrigin.SetValue(0.5f, 0.5f);
 *   view2.viewportSize.SetValue(0.5f, 0.5f);
 *   SoPerspectiveCamera cam2 = new SoPerspectiveCamera();
 *   view2.SetPart("cameraKit.camera", cam2);
 *   view2.SetPart("scene", scene2);
 *   cam2.ViewAll(scene2, new SbViewportRegion(100, 100));
 *   root.AddChild(view2);
 *
 *   viewer.SetSceneGraph(root);
 *   \endcode
 * \endif
 * \if_java
 *   \code
 *   // Must enable this option or viewer will not be able to find the camera in the PoSceneView nodeKit.
 *   SoBaseKit.setSearchingChildren( true );
 *
 *   // First scene graph
 *   SoSeparator scene1 = new SoSeparator();
 *   scene1.addChild( new SoCone() );
 *
 *   // First view (lower left quadrant of window)
 *   PoSceneView view1 = new PoSceneView();
 *   view1.sensitiveOnEvents( true );
 *   view1.isBorderVisible.setValue( true );
 *   view1.viewportOrigin.setValue( 0, 0 );
 *   view1.viewportSize.setValue( 0.5f, 0.5f );
 *   SoPerspectiveCamera cam1 = new SoPerspectiveCamera();
 *   view1.setPart( "cameraKit.camera", cam1 );
 *   view1.setPart( "scene", scene1 );
 *   cam1.viewAll( scene1, new SbViewportRegion((short)100, (short)100) );
 *   root.addChild( view1 );
 *
 *   // Second scene graph
 *   Separator scene2 = new SoSeparator();
 *   scene2.addChild( new SoCube() );
 *
 *   // Second view (upper right quadrant of window)
 *   PoSceneView view2 = new PoSceneView();
 *   view2.sensitiveOnEvents( true );
 *   view2.isBorderVisible.setValue( true );
 *   view2.set( "borderApp.drawStyle", "lineWidth 1.5" ); // Work-around for border
 *   view2.viewportOrigin.setValue( 0.5f, 0.5f );
 *   view2.viewportSize.setValue( 0.5f, 0.5f );
 *   SoPerspectiveCamera cam2 = new SoPerspectiveCamera();
 *   view2.setPart( "cameraKit.camera", cam2 );
 *   view2.setPart( "scene", scene2 );
 *   cam2.viewAll( scene2, new SbViewportRegion((short)100, (short)100) );
 *   root.addChild( view2 );
 *
 *   viewer.setSceneGraph( root );
 *   \endcode
 * \endif
 * 
 * @FILE_FORMAT_DEFAULT
 *    PoSceneView {
 *    @TABLE_FILE_FORMAT
 *       @TR viewportOrigin @TD 0 0
 *       @TR viewportSize @TD 1 1
 *       @TR isBackgroundVisible @TD FALSE
 *       @TR isBorderVisible @TD FALSE
 *    @TABLE_END
 *    }
 * 
 * @CATALOG_PARTS_INCLUDE posceneview.cat.html
 * 
 * 
 */
class INVENTORGUI_API PoSceneView : public PoBaseView 
{
  SO_KIT_HEADER(PoSceneView) ;

  /* Define fields for new parts */
  SO_KIT_CATALOG_ENTRY_HEADER(backgroundSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(backgroundApp) ;
  SO_KIT_CATALOG_ENTRY_HEADER(background) ;

  SO_KIT_CATALOG_ENTRY_HEADER(topSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(sceneSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(scene) ;

  SO_KIT_CATALOG_ENTRY_HEADER(borderSep) ;
  SO_KIT_CATALOG_ENTRY_HEADER(borderApp) ;
  SO_KIT_CATALOG_ENTRY_HEADER(border) ;


 public:

  /**
   * Default constructor.
   */
  PoSceneView() ;

  /* Fields */

  /**
   * Defines the visibility of the background of the view.
   */
  SoSFBool isBackgroundVisible ;

  /**
   * Defines the visibility of the borders of the view.
   */
  SoSFBool isBorderVisible ;

  /*----------------------------------------------------------------------------*/
 SoINTERNAL public:
  static void initClass() ;
	static void exitClass() ;

 protected:
  // Methods
  // Destructor
  virtual ~PoSceneView() ;
  virtual void   setDefaultOnNonWritingFields() ;

 private:


  // Draw the border of the view
  void drawBorder() ;

  // Draw the background of the view
  void drawBackground() ;

  // This sensor watches for changes of isBackgroundVisible field
  SoFieldSensor *isBackgroundVisibleSensor ;

  // This sensor watches for changes of isBorderVisible field
  SoFieldSensor *isBorderVisibleSensor ;  
  static void fieldSensorCB(void *data, SoSensor *sensor) ;

  virtual SbBool setUpConnections(SbBool onOff, SbBool doItAlways = FALSE) ;
  virtual SbBool readInstance(SoInput *in, unsigned short flags);
} ;

/*----------------------------------------------------------------------------*/

#endif /* _PO_SCENE_VIEW_  */


