/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Jun 2007)
**=======================================================================*/


#ifndef SO_GUI_PLANE_VIEWER
#define SO_GUI_PLANE_VIEWER

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoGuiPlaneViewer
//
// SoXXPlaneViewer implementation class
// 
//
//////////////////////////////////////////////////////////////////////////////


#include <Inventor/Gui/viewers/SoGuiAlgoViewers.h>

/** [OIV-WRAPPER-NO-WRAP] */
class INVENTORGUI_API SoGuiPlaneViewer : public SoGuiAlgoViewers 
{
#ifndef HIDDEN_FROM_DOC
  SO_FIELDCONTAINER_HEADER( SoGuiPlaneViewer );
#endif

SoINTERNAL public:
  //  Defines
  enum ViewerModes 
  {
    PICK_MODE, 
    VIEW_MODE,
    DOLLY_MODE_ACTIVE, 
    PAN_MODE, 
    PAN_MODE_ACTIVE, 
    ROLL_MODE_ACTIVE, 
    SEEK_MODE 
  };

// list of custom push buttons
  enum 
  {
    X_PUSH = 0, 
    Y_PUSH,
    Z_PUSH,
    CAM_PUSH,
    PUSH_NUM
  };

  /**
   * Constructor.
   */
  SoGuiPlaneViewer();

  virtual void setCursorEnabled( SbBool onOrOff );
  SbBool isCursorEnabled() const;
  virtual void setSeekMode( SbBool onOrOff );

  // ----------------------- Extension usage -----------------------------------

  virtual void actualRedraw();

protected:
  /**
   * Destructor.
   */
  virtual ~SoGuiPlaneViewer();
};


#endif  // SO_GUI_PLANE_VIEWER

