/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. HUFSCHMITT (Jul 2001)
**=======================================================================*/

                                                             /* include files */
#ifndef _SO_MPEGFRAMERENDERER_
#define _SO_MPEGFRAMERENDERER_

#include <Inventor/MPEG/SoMPEGRenderer.h>
#include <Inventor/SbViewportRegion.h>
#include <Inventor/SoOffscreenRenderArea.h>

/*----------------------------------------------------------------------------*/

/**
 * @VSGEXT Generates MPEG output, frame by frame.
 * 
 * @ingroup MPEG
 * 
 * @DESCRIPTION
 *   This class generates MPEG output, frame by frame.
 *
 *   See the parent class SoMPEGRenderer for methods to specify the file and
 *   recording parameters.
 *   
 * @SEE_ALSO
 *    SoMPEGRenderer, SoMPEGNavRenderer
 * 
 * 
 */
class INVENTOR_API SoMPEGFrameRenderer : public SoMPEGRenderer {

 public:
  /**
   * Constructor.
   */
  SoMPEGFrameRenderer ();

  /**
   * Destructor.
   */
  virtual ~SoMPEGFrameRenderer ();

  /**
   * Adds a new frame to the current MPEG output.
   * The duration (specified in seconds) is used to determine how many times 
   * this frame must be played in the MPEG output depending on the current 
   * number of frames per second (as specified by the method 
   * SoMPEGRenderer::setNumFramesPerSecond()).
   */
  void recordFrame(float duration=0) ;

  /*----------------------------------------------------------------------------*/

 private:
  SoRef<SoOffscreenRenderArea> m_OSRenderArea;
  SbViewportRegion *m_View;

} ;/*----------------------------------------------------------------------------*/

#endif /* _SO_MPEGFRAMERENDERER_ */


