/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nick Thompson (MMM yyyy)
** Modified by : Paul Isaacs (MMM yyyy)
** Modified by : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef _SO_QT_
#define _SO_QT_

#ifndef SOQT
#define SOQT
#endif

#include <Inventor/Qt/SoXt2SoQt.h>

#include <qglobal.h>

#include <QEvent>
#include <QObject>
#include <QWidget>
#include <QToolButton>
#include <QPushButton>
#include <QApplication>
#include <QPointer>

#include <Inventor/SbLinear.h>
#include <Inventor/SbString.h>
#include <Inventor/Qt/SoQtDef.h>
#include <Inventor/Qt/SoInventorQtLibName.h>

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoInventorQt, __INVENTORQTDLL)

#ifdef _WIN32
#if !defined(InventorQt_EXPORTS)
#ifndef OIV_DISABLE_AUTOLINK
#  pragma comment(lib,__INVENTORQTLIB)
#endif
#endif
#endif //win

class SbPList;
class SoQtSensorHandler;
class SoAction;

/**
 * @VSGEXT Routines for Open Inventor/Qt compatibility.
 *
 * @ingroup Qt
 *
 * @DESCRIPTION
 *   The SoQt class initializes Open Inventor for use with Qt.
 *   SoQt::init() must be called in order for Open Inventor to work properly with
 *   Qt. SoQt::finish() should be called to clean up static memory allocations.
 *
 *   SoQt::mainLoop() must be called in order for extension device messages
 *   to be passed to Open Inventor render areas. The other methods are convenience
 *   functions.
 *
 *   Refer to the SoQtComponent reference pages for examples on how this class should
 *   be used when using Open Inventor Qt components.
 *
 * @SEE_ALSO
 *    SoQtComponent
 *
 *
 */
class INVENTORQT_API  SoQt : public QObject
{
  Q_OBJECT
    // QObject inheritance is not required here.
    // Just for consistency and to allow possible Q_SLOTS.
    public:
  /**
   * This is called to initialize Open Inventor and Qt, and bind Open Inventor
   * with Qt message handling so that Open Inventor sensors will work correctly.
   * This returns the top level shell widget handle. This method calls
   * SoDB::init(), SoNodeKit::init(), and SoInteraction::init(),
   * and creates an initial window.
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE static QWidget *init(const char *appName, const char *className = "Inventor");

  /**
   * This is called to initialize Open Inventor and Qt, and bind Open Inventor
   * with Qt message handling so that Open Inventor sensors will work correctly.
   * This returns the top level shell widget handle. This method calls
   * SoDB::init(), SoNodeKit::init(), and SoInteraction::init(),
   * and creates an initial window.
   */
  static QWidget *init(const SbString& appName, const SbString& className = "Inventor");

  /**
   * This alternate form of init allows the application to initialize Qt. The
   * passed widget handle should be the top level widget handle returned from the
   * Qt initialization. This method will call SoDB::init(),
   * SoNodeKit::init(), and SoInteraction::init().
   */
  static void init( QWidget *topLevelWidget );

#if SoDEPRECATED_BEGIN(10000)
  /**
   * @UNICODE_WARNING
   */
  SoDEPRECATED_METHOD(10000, "Use SoQt::init( appName, className ) instead.")
  SoNONUNICODE static QWidget *threadInit(const char *appName,
                             const char *className = "Inventor");

  SoDEPRECATED_METHOD(10000, "Use SoQt::init( appName, className ) instead.")
  static QWidget *threadInit(const SbString& appName,
                             const SbString& className = "Inventor");

  SoDEPRECATED_METHOD(10000, "Use SoQt::init( topLevelWidget ) instead.")
  static void threadInit(QWidget *topLevelWidget);
#endif /** @DEPRECATED_END */

  /**
   * Convenience routine to show the passed widget handle.
   *
   * This includes any children the widget may have.
   */
  static void show(QWidget *widget);
  /**
   * Convenience routine to hide the passed widget handle.
   *
   * This includes any children the widget may have.
   */
  static void     hide(QWidget *widget);

  /**
   * Enters the main event loop and waits until #exit() is called
   * or QCoreApplication::exit() is called.
   * Returns the value that was passed to #exit() or QCoreApplication::exit().
   *
   * It calls #nextEvent() and #dispatchEvent() to retrieve and dispatch events.
   */
  static int mainLoop();

  /**
   * Tells the main event loop to exit with a return code.
   *
   * After this function has been called, the #mainLoop() function returns returnCode.
   * If the event loop is not running, this function does nothing.
   *
   * By convention, a returnCode of 0 means success, and any non-zero value indicates an error.
   */
  static void exit(int returnCode = 0);

  /**
  * This method is included for portability only.
  * So that code written for Xt can be used also on Qt implementations.
  */
  static void nextEvent(XtAppContext appContext, XEvent *event);
  /**
   * This method is included for portability only.
   */
  static SbGlContextHelper::Display getDisplay();
  /**
  * This method is included for portability only.
  * So that code written for Xt can be used also on Qt implementations.
  */
  static SbGlContextHelper::GLContext getAppContext();
  /**
  * This method is included for portability only.
  * It processes all the pending events
  * So that code written for Xt can be used also on Qt implementations.
  */
  static Boolean dispatchEvent(XEvent *);
  /**
   * Returns information based on the initial QWidget handle returned by or passed to
   * init.
  */
  static QWidget *getTopLevelWidget();
  /**
   * Convenience routine to set the size of the given widget.
   */
  static void     setWidgetSize(QWidget *widget, const SbVec2s &size);
  /**
   * Convenience routine to get the size of the given widget.
   */
  static SbVec2s getWidgetSize(QWidget *widget);

  /**
   * Convenience routine which brings a simple Qt error dialog box displaying
   * the given error string(s) and window title. The OK button, which destroys the
   * dialog, is the only button displayed.
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE static void createSimpleErrorDialog(QWidget *widget, char *dialogTitle,
                                      char *errorStr1, char *errorStr2 = NULL);

  /**
   * Convenience routine which brings a simple Qt error dialog box displaying
   * the given error string(s) and window title. The OK button, which destroys the
   * dialog, is the only button displayed.
   */
  static void createSimpleErrorDialog( QWidget *widget, const SbString& sdialogTitle,
                                      const SbString& errorStr1, const SbString& errorStr2 = "" );

  /**
   * Frees Open Inventor's internal static memory
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application. This method calls SoDB::finish(),
   * SoNodeKit::finish(), and SoInteraction::finish().
   *
   *@B Note@b: Open Inventor objects should be destroyed before you call this method.
   *
   * For example:
   * @TABLE_1B
   *  @TR @B Wrong Open Inventor Ending@b
   *  @TD @B Safe Open Inventor Endings@b
   *  @TR \code
   * void main() {
   *   QWidget myW = SoQt::init("");
   *   SoQtExaminerViewer viewer( myW );
   *   ....
   *   ....
   *   SoQt::mainLoop();
   *   SoQt::finish();
   * }
   *  \endcode
   *  @TD
   *    @TABLE_0B
   *    @TR \code
   * void runApp() {
   *   SoQtExaminerViewer viewer( myW );
   *   ....
   *   ....
   *   SoQt::mainLoop();
   * }
   *
   * void main () {
   *   QWidget myW = SoQt::init("");
   *   runApp();
   *   SoQt::finish();
   * }
   * \endcode
   * @TD \code
   * void main () {
   *   QWidget myW = SoQt::init("");
   *   SoQtExaminerViewer* viewer
   *          = new SoQtExaminerViewer( myW );
   *   ....
   *   ....
   *   SoQt::mainLoop();
   *   delete viewer;
   *   SoQt::finish();
   *  }
   * \endcode
   *     @TABLE_END
   * @TR
   * SoQt doesn't end properly: SoQtExaminerViewer is destroyed after the #finish() method has been called.
   * @TD
   * The SoQtExaminerViewer (that uses Open Inventor) is destroyed before calling the #finish() method.
   *     @TABLE_END
   */
  static void finish();

  /**
   * Returns TRUE if SoQt module is currently initialized.
   */
  static bool isInitialized();

  /**
   * Returns the type number of the Open Inventor
   * extension QCustomEvent. This number can be set with
   * the environment variable OIV_EXTENSION_EVENT_NUMBER.
   */
  static int getExtensionEventNumber();

SoINTERNAL public:
  // Hide from docs...

  static QPointer<QWidget> mainWidget;
  static QPointer<QApplication> qapplication;
  static QApplication *getQApp() {return qapplication;};

  // Add/remove the passed event handler for X extension device events
  // (Xt does not handle extension events.)
  // Extension event types are queried from the server at runtime.
  static void addExtensionEventHandler(QWidget *w,
                                       int extensionEventType,
                                       XtEventHandler proc,
                                       XtPointer clientData);
  static void removeExtensionEventHandler(QWidget *w,
                                          int extensionEventType,
                                          XtEventHandler proc,
                                          XtPointer clientData);

  static void   getExtensionEventHandler(XEvent *event, QWidget *w,
                                         XtEventHandler &proc,
                                         XtPointer &clientData);

protected:

  static SoQtSensorHandler *sensorHandler;

private:

  // Code factorization for init(SbString&, SbString&) and threadInit(SbString&, SbString&)
  // Return true if init is ok (false if init is already done)
  static bool commonInit(const SbString& appName, const SbString& className);

  static void setupInventorGLDisplay();

  static int s_returnCode;

  static SbPList *handlerList;
  static int OIVExtensionEventNumber;
  static int s_initRefCount;
  static const char *s_versionString;
  static SbBool s_ownTopLevelWindow;
  static SbBool s_ownApplication;
  static int s_defaultArgc;
  static char** s_defaultArgv;
};

#ifdef __APPLE__
#define SoQtButton QToolButton
#else
#define SoQtButton QPushButton
#endif

#endif // _SO_QT_


