/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/

#ifndef  _SO_QT_COLOR_PATCH_
#define  _SO_QT_COLOR_PATCH_

#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/SoQtGLWidget.h>
#include <Inventor/SbColor.h>


//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoQtColorPatch
//
//      This class simply draws a 3D looking patch of color.
//
//////////////////////////////////////////////////////////////////////////////

SoINTERNAL class INVENTORQT_API SoQtColorPatch : public SoQtGLWidget {

  Q_OBJECT

public:
    
  SoQtColorPatch(QWidget *parent = NULL,
                 const char *name = NULL, 
                 SbBool buildInsideParent = TRUE);

  ~SoQtColorPatch();
    
  //
  // set/get routines to specify the patch top color
  //
  void                setColor(const SbColor &rgb);
  const SbColor &     getColor()      { return color; }
  
protected:

  // This constructor takes a boolean whether to build the widget now.
  // Subclasses can pass FALSE, then call SoQtSlider::buildWidget()
  // when they are ready for it to be built.
  SoEXTENDER
  SoQtColorPatch(
                 QWidget *parent,
                 const char *name, 
                 SbBool buildInsideParent, 
                 SbBool buildNow);
    
private:
    
  // redefine to do ColorPatch specific things
  virtual void    redraw();
  virtual void    sizeChanged(const SbVec2s &newSize);
    
  // local variables
  SbColor     color;

  // this is called by both constructors
  void constructorCommon(SbBool buildNow);
};

#endif  // _SO_QT_COLOR_PATCH_


