/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_QT_DEF_
#define _SO_QT_DEF_

#include <Inventor/helpers/SbGlContextHelper.h>

// avoid conflict with declaration made in X headers
//#if defined (Bool)
//#undef Bool
//#endif

#if !defined(Widget)

#if defined(SoWidget)
# undef SoWidget
#endif

#define SoWidget QWidget*

// Defined for compatibility purpose
// We disbale this when internally compiling OivSuite
#ifndef LIBRARYBUILD
#  define Widget QWidget*
#endif

#endif


//
// WIN32
// 
#ifdef _WIN32

// Redefine X data types in _WIN32 terms
#define XColor      UINT
#define Boolean     BOOLEAN
#define Colormap    UINT
typedef SbGlContextHelper::Display Display; 
#define XVisualInfo PIXELFORMATDESCRIPTOR
#define WindowQt    HWND
#define GLXContext  HGLRC
#define Hdc         HDC

// Event types
#define XEvent      MSG

// Redefine Xt and Motif data types in _WIN32 terms
#define XtPointer      PVOID
#define XtEventHandler FARPROC
#define XtAppContext   UINT

#include "tchar.h"

// XVisualInfo corresponds to PIXELFORMATDESCRIPTOR rather than
// "pixel format" because under Windows, pixel formats are per
// drawable rather than per display (like visuals under X).  In
// other words, under Windows we can't get the description of a
// pixel format unless we have a valid device context and that
// is often inconvenient.
//
// Note that PIXELFORMATDESCRIPTOR also takes the place of GLX's
// "attribList" (which it is conceptually closer to).

#define XVisualInfo PIXELFORMATDESCRIPTOR

//
// APPLE
// 
#elif defined __APPLE__

#ifndef BOOLEAN_TYPE_EXISTS
typedef unsigned char Boolean;
#define BOOLEAN_TYPE_EXISTS
#endif

#undef Display
/** @ingroup InventorViewers */
typedef int Display;
#define XColor      UINT
/** @ingroup InventorViewers */
typedef WId WindowQt;
/** @ingroup InventorViewers */
typedef WId Window;

// Event types
#define XEvent void*

// Redefine Xt and Motif data types in _WIN32 terms
#define XtPointer      void*
#define XtEventHandler void*
#define XtAppContext   void*

//
// UNIX
// 
#else

#define WindowQt Window
/** @ingroup InventorViewers */
typedef void* XtPointer;
/** @ingroup InventorViewers */
typedef char Boolean;
/** @ingroup InventorViewers */
typedef union _XEvent XEvent;
/** @ingroup InventorViewers */
typedef void (*XtEventHandler) (struct _WidgetRec*, void*, XEvent*, Boolean*);
/** @ingroup InventorViewers */
typedef struct _XtAppStruct* XtAppContext;

// we use XColorPointer typedef to avoid X header dependency in public API headers
// XColorPointer is equivalent to XColor*
/** @ingroup InventorViewers */
typedef void* XColorPointer;

#endif 

#endif //_SO_QT_DEF_


