/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/SbBasic.h>
#include <Inventor/SbTime.h>

#include <QObject>
#include <QPointer>

class QTimer;
class SoTimerThread;

/**
 * This class ties Inventor sensors into the Qt event queue.
 */
SoINTERNAL class INVENTORQT_API SoQtSensorHandler : public QObject
{
  Q_OBJECT

  public:
  SoQtSensorHandler();
  ~SoQtSensorHandler();

  protected Q_SLOTS:
  void processNextTimerSensor();
  void processNextDelaySensor();
  void processNextDelaySensorTimeout();

  protected:

  // Callback for changes to the sensor manager
  static void sensorManagerChangedCallback(void *data);

  void setUpPendingTimers();
  void setUpTimerSensor();
  void setUpDelaySensor();
  void setUpDelaySensorTimeout();

  // Allows timer thread to post timeout events
  void customEvent( );

  QPointer<QTimer> timedSensorTimer;
  QPointer<QTimer> delaySensorTimer;
  QPointer<QTimer> delaySensorTimeout;

  // Internal class for managing timer in separate thread
  SoTimerThread *m_timerThread;

  // Internal deadline to decide if we have to reschedule or not the sensor
  SbTime currentDeadLine;
};


