/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _SO_QT_FOCUS_
#define  _SO_QT_FOCUS_

#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/devices/SoQtDevice.h>

#define SO_QT_ALL_FOCUS_EVENTS \
        (EnterWindowMask | LeaveWindowMask)


SoEXTENDER class INVENTORQT_API SoQtInputFocus : public SoQtDevice {

  Q_OBJECT

    public:
  /**
   * Constructor. To the constructor, pass which input focus events
   * you are interested in as a bitwise OR of the following values: 
   * 
   * EnterWindowMask - Input focus entered the window. 
   * 
   * LeaveWindowMask - Input focus left the window 
   * 
   * Or simply pass the defined value SO_QT_ALL_FOCUS_EVENTS for all input focus
   * events. 
   */
  SoQtInputFocus(EventMask mask = SO_QT_ALL_FOCUS_EVENTS);
  /**
   * Destructor. 
   */
  ~SoQtInputFocus() {}
    
  // these functions will enable/disable this device for the passed widget.
  // the callback function f will be invoked when events occur in w.
  // data is the clientData which will be passed.
  virtual void        enable(QWidget *w, XtEventHandler f, XtPointer data , void* unused=NULL);
  virtual void        disable(QWidget *w, XtEventHandler f, XtPointer data);
  //
  // this converts an X event into an SoEvent,
  // returning NULL if the event is not from this device.
  //
  virtual const SoEvent * translateEvent(QEvent *event);
  
 private:
  EventMask           eventMask;

};

#endif /* _SO_QT_FOCUS_ */


