/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _SO_QT_KEYBOARD_
#define  _SO_QT_KEYBOARD_
#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/devices/SoQtDevice.h>
#include <Inventor/events/SoKeyboardEvent.h>

class QKeyEvent;

#define SO_QT_ALL_KEYBOARD_EVENTS (KeyPressMask | KeyReleaseMask)

/** 
 * @VSGEXT Translates and reports events for the keyboard device.
 * 
 * @ingroup Qt
 * 
 * @DESCRIPTION
 *   This class manages events generated by the keyboard, including key press and
 *   release events (SoKeyboardEvent).
 * 
 * @B Note @b: @BR
 * With Qt, there is no difference between the left and right Window/Meta keys. 
 * So SoKeyboardEvent::LEFT_META is returned when either of these keys is pressed.
 *
 * @SEE_ALSO
 *    SoQtDevice,
 *    SoKeyboardEvent
 * 
 * 
 */
class INVENTORQT_API SoQtKeyboard : public SoQtDevice {

  Q_OBJECT

    public:
  /**
   * Constructor. To the constructor, pass which keyboard events you
   * are interested in as a bitwise OR of the following values:
   * 
   * KeyPressMask - Key press messages
   * 
   * KeyReleaseMask - Key release messages
   * 
   * Or simply pass the defined value SO_QT_ALL_KEYBOARD_EVENTS for all keyboard
   * events. The device will only report events of this type for the widget it is
   * enabled on.
   */
  SoQtKeyboard(EventMask mask = SO_QT_ALL_KEYBOARD_EVENTS);
  /**
   * Destructor. 
   */
  ~SoQtKeyboard();
    
  /** @copydoc SoQtDevice::enable() */
  virtual void        enable(QWidget *w, XtEventHandler f, XtPointer data, void* unused=NULL);

  /** @copydoc SoQtDevice::disable() */
  virtual void        disable(QWidget *w, XtEventHandler f, XtPointer data);
    
  /** @copydoc SoQtDevice::translateEvent() */
  virtual const SoEvent * translateEvent(QEvent *event);
  
 private:
  EventMask           eventMask;      // Q event interest for this device
  SoKeyboardEvent     *keyEvent;      // keyboard press or release
  SoKeyboardEvent *translateKeyEvent(QKeyEvent *ke, SoButtonEvent::State s);

  // Mapping from QT virtual keys to SoKeyboardEvent::Key enum
  static SoKeyboardEvent::Key keyMap[256];
  static SoKeyboardEvent::Key keyMap2[97];
  static int keyMapInitFlag;


};

#endif /* _SO_QT_KEYBOARD_ */


