/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/


#ifndef  _SO_QT_MOUSE_
#define  _SO_QT_MOUSE_
#include <Inventor/Qt/OivQtCompat.h>
#include <Inventor/Qt/devices/SoQtDevice.h>
#include <Inventor/events/SoLocation2Event.h>
#include <Inventor/events/SoMouseButtonEvent.h>
#include <Inventor/events/SoMouseWheelEvent.h>

#define SO_QT_ALL_MOUSE_EVENTS \
    (ButtonPressMask | ButtonReleaseMask | \
     PointerMotionMask | ButtonMotionMask)

class QMouseEvent;
class QWheelEvent;
/**
 * @VSGEXT Translates and reports events for the mouse device.
 * 
 * @ingroup Qt
 * 
 * @DESCRIPTION
 *   This class manages events generated by the mouse, including mouse motion
 *   (SoLocation2Event), and mouse button press and release events
 *   (SoMouseButtonEvent).
 * 
 * @SEE_ALSO
 *    SoQtDevice,
 *    SoLocation2Event,
 *    SoMouseButtonEvent
 *    SoMouseWheelEvent
 * 
 * 
 */
class INVENTORQT_API SoQtMouse : public SoQtDevice {

  Q_OBJECT

    public:
  /**
   * Constructor. To the constructor, pass which mouse messages you
   * are interested in as a bitwise OR of the following values:
   * 
   * ButtonPressMask - Mouse down events
   * 
   * ButtonReleaseMask - Mouse up events
   * 
   * PointerMotionMask - Mouse motion with no buttons
   * 
   * ButtonMotionMask - Mouse motion with buttons pressed
   * 
   * Or simply pass the defined value SO_QT_ALL_MOUSE_EVENTS for all mouse events. The
   * device will only report events of this type for the window it is enabled on.
   */
  SoQtMouse(EventMask mask = SO_QT_ALL_MOUSE_EVENTS);
  /**
   * Destructor. 
   */
  ~SoQtMouse();
    
  /** @copydoc SoQtDevice::enable() */
  virtual void        enable(QWidget *w, XtEventHandler f, XtPointer data, void *unused=NULL);

  /** @copydoc SoQtDevice::disable() */
  virtual void        disable(QWidget *w, XtEventHandler f, XtPointer data);
    
  /** @copydoc SoQtDevice::translateEvent() */
  virtual const SoEvent * translateEvent(QEvent *event);
  
 private:
  EventMask                   eventMask;      // Q event interest for this device
  SoLocation2Event    *loc2Event;     // mouse motion
  SoMouseButtonEvent  *buttonEvent;   // mouse button press
  SoMouseWheelEvent   *mouseWheelEvent;

  SoLocation2Event    *translateMotionEvent(QMouseEvent *me);
  SoMouseButtonEvent  *translateButtonEvent(QMouseEvent *be, SoButtonEvent::State s);
  SoMouseWheelEvent   *translateMouseWheelEvent(QWheelEvent *we); 
};

#endif /* _SO_QT_MOUSE_ */


